package com.vungle.ads.internal

import android.content.Context
import android.os.Build
import com.vungle.ads.AnalyticsClient
import com.vungle.ads.BidTokenCallback
import com.vungle.ads.BuildConfig
import com.vungle.ads.SdkVersionTooLow
import com.vungle.ads.ServiceLocator.Companion.inject
import com.vungle.ads.TimeIntervalMetric
import com.vungle.ads.VungleAds
import com.vungle.ads.internal.bidding.BidTokenEncoder
import com.vungle.ads.internal.executor.SDKExecutors
import com.vungle.ads.internal.privacy.PrivacyManager
import com.vungle.ads.internal.protos.Sdk
import com.vungle.ads.internal.util.Utils

internal class VungleInternal {

    /**
     * Will return an encoded string of advertisement bidding token.
     */
    fun getAvailableBidTokensAsync(context: Context, callback: BidTokenCallback) {
        if (Utils.isOSVersionInvalid()) {
            val error = "RTB: SDK is supported only for API versions ${Build.VERSION_CODES.N_MR1} and above."
            SdkVersionTooLow(error).logErrorNoReturnValue()
            callback.onBidTokenError(error)
            return
        }

        if (!VungleAds.isInitialized()) {
            PrivacyManager.init(context.applicationContext)
        }

        val bidTokenEncoder: BidTokenEncoder by inject(context)
        val sdkExecutors: SDKExecutors by inject(context)
        sdkExecutors.apiExecutor.execute {
            val bidTokenDurationMetric =
                TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.BID_TOKEN_REQUEST_TO_RESPONSE_DURATION_MS)
            bidTokenDurationMetric.markStart()

            val bidTokenInfo = bidTokenEncoder.encode()

            bidTokenDurationMetric.markEnd()
            if (bidTokenInfo.bidToken.isNotEmpty()) {
                callback.onBidTokenCollected(bidTokenInfo.bidToken)
            } else {
                bidTokenDurationMetric.metricType =
                    Sdk.SDKMetric.SDKMetricType.BID_TOKEN_REQUEST_TO_FAIL_DURATION_MS
                bidTokenDurationMetric.meta = bidTokenInfo.errorMessage
                callback.onBidTokenError(bidTokenInfo.errorMessage)
            }

            AnalyticsClient.logMetric(bidTokenDurationMetric)
        }
    }

    fun getSdkVersion() = BuildConfig.VERSION_NAME
}
