package com.vungle.ads.fpd

import com.vungle.ads.internal.util.RangeUtil
import kotlinx.serialization.InternalSerializationApi
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@OptIn(InternalSerializationApi::class) @Serializable
class SessionContext {
    @SerialName("level_percentile")
    private var levelPercentile: Float? = null

    // Setter methods
    fun setLevelPercentile(levelPercentile: Float): SessionContext {
        if (RangeUtil.isInRange(levelPercentile, 0f, 100f)) {
            this.levelPercentile = levelPercentile
        }
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setPage(page: String): SessionContext {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setTimeSpent(timeSpent: Int): SessionContext {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setSignupDate(signupDate: Int): SessionContext {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setUserScorePercentile(userScorePercentile: Float): SessionContext {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setUserID(userID: String): SessionContext {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setFriends(friends: List<String>?): SessionContext {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setUserLevelPercentile(userLevelPercentile: Float): SessionContext {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setHealthPercentile(healthPercentile: Float): SessionContext {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setSessionStartTime(sessionStartTime: Int): SessionContext {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setSessionDuration(sessionDuration: Int): SessionContext {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setInGamePurchasesUSD(inGamePurchasesUSD: Float): SessionContext {
        return this
    }
}