package com.vungle.ads.fpd

import kotlinx.serialization.InternalSerializationApi
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

enum class LiftoffGender(val value: Int) {
    FEMALE(0),
    MALE(1)
}

@OptIn(InternalSerializationApi::class) @Serializable
class Demographic {

    @SerialName("age_range")
    private var ageRange: Int? = null

    @SerialName("gender")
    private var gender: Int? = null

    fun setGender(gender: LiftoffGender): Demographic {
        this.gender = gender.value
        return this
    }

    fun setAgeRange(age: Int): Demographic {
        this.ageRange = AgeRange.fromAge(age).id
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setLengthOfResidence(lengthOfResidence: Int): Demographic {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setMedianHomeValueUSD(homeValue: Int): Demographic {
        return this
    }

    @Deprecated("Will be deprecated", ReplaceWith(""))
    fun setMonthlyHousingCosts(housingCost: Int): Demographic {
        return this
    }
}

enum class AgeRange(val id: Int, val range: IntRange) {
    AGE_18_20(1, 18..20),
    AGE_21_30(2, 21..30),
    AGE_31_40(3, 31..40),
    AGE_41_50(4, 41..50),
    AGE_51_60(5, 51..60),
    AGE_61_70(6, 61..70),
    AGE_71_75(7, 71..75),
    OTHERS(0, Int.MIN_VALUE..Int.MAX_VALUE);  // Default range for others

    companion object {
        internal fun fromAge(age: Int): AgeRange {
            return values().firstOrNull { age in it.range } ?: OTHERS
        }
    }
}

