package com.vungle.ads.internal.util

import android.os.Build
import android.webkit.URLUtil

internal object Utils {
    fun isUrlValid(url: String?): Boolean {
        return !url.isNullOrEmpty() && (URLUtil.isHttpsUrl(url) || URLUtil.isHttpUrl(url))
    }

    fun isOSVersionInvalid(): Boolean {
        return Build.VERSION.SDK_INT < Build.VERSION_CODES.N_MR1
    }
}
