package com.vungle.ads.internal.platform

import android.content.Context
import android.os.Build
import android.util.AndroidRuntimeException
import android.view.View
import com.vungle.ads.internal.util.Logger
import android.webkit.WebSettings
import android.webkit.WebView
import androidx.core.util.Consumer
import com.vungle.ads.BuildConfig
import com.vungle.ads.internal.model.AdPayload
import java.lang.Exception

object WebViewUtil {

    private const val TAG = "WebViewUtil"

    fun getUserAgent(context: Context, consumer: Consumer<String?>) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            try {
                val userAgent = WebSettings.getDefaultUserAgent(context)
                consumer.accept(userAgent)
            } catch (e: Exception) {
                if (e is AndroidRuntimeException) {
                    Logger.e(TAG, "WebView could be missing here")
                }
                consumer.accept(null)
            }
            return
        }
        consumer.accept(null)
    }

    fun applyWebSettings(webView: WebView, webViewSettings: AdPayload.WebViewSettings?) {
        val webSettings = webView.settings
        webSettings.builtInZoomControls = false
        webSettings.javaScriptEnabled = true
        webSettings.loadWithOverviewMode = true
        webSettings.saveFormData = true
        webSettings.useWideViewPort = false
        webSettings.allowFileAccess = true
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            webSettings.allowFileAccessFromFileURLs =
                webViewSettings?.allowFileAccessFromFileUrls ?: false
            webSettings.allowUniversalAccessFromFileURLs =
                webViewSettings?.allowUniversalAccessFromFileUrls ?: false
        }
        webView.visibility = View.INVISIBLE
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            webSettings.mediaPlaybackRequiresUserGesture = false
        }
        if (BuildConfig.DEBUG && Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            WebView.setWebContentsDebuggingEnabled(true)
        }
    }
}
