package com.vungle.ads.fpd

import com.vungle.ads.internal.util.RangeUtil
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
class SessionContext {
    @SerialName("level_percentile")
    private var levelPercentile: Float? = null

    @SerialName("page")
    private var page: String? = null

    @SerialName("time_spent")
    private var timeSpent: Int? = null

    @SerialName("signup_date")
    private var signupDate: Int? = null

    @SerialName("user_score_percentile")
    private var userScorePercentile: Float? = null

    @SerialName("user_id")
    private var userID: String? = null

    @SerialName("friends")
    private var friends: MutableList<String>? = null

    @SerialName("user_level_percentile")
    private var userLevelPercentile: Float? = null

    @SerialName("health_percentile")
    private var healthPercentile: Float? = null

    @SerialName("session_start_time")
    private var sessionStartTime: Int? = null

    @SerialName("session_duration")
    private var sessionDuration: Int? = null

    @SerialName("in_game_purchases_usd")
    private var inGamePurchasesUSD: Float? = null

    // Setter methods
    fun setLevelPercentile(levelPercentile: Float): SessionContext {
        if (RangeUtil.isInRange(levelPercentile, 0f, 100f)) {
            this.levelPercentile = levelPercentile
        }
        return this
    }

    fun setPage(page: String): SessionContext {
        this.page = page
        return this
    }

    fun setTimeSpent(timeSpent: Int): SessionContext {
        this.timeSpent = timeSpent
        return this
    }

    fun setSignupDate(signupDate: Int): SessionContext {
        this.signupDate = signupDate
        return this
    }

    fun setUserScorePercentile(userScorePercentile: Float): SessionContext {
        if (RangeUtil.isInRange(userScorePercentile, 0f, 100f)) {
            this.userScorePercentile = userScorePercentile
        }
        return this
    }

    fun setUserID(userID: String): SessionContext {
        this.userID = userID
        return this
    }

    fun setFriends(friends: List<String>?): SessionContext {
        this.friends = friends?.toMutableList()
        return this
    }

    fun setUserLevelPercentile(userLevelPercentile: Float): SessionContext {
        if (RangeUtil.isInRange(userLevelPercentile, 0f, 100f)) {
            this.userLevelPercentile = userLevelPercentile
        }
        return this
    }

    fun setHealthPercentile(healthPercentile: Float): SessionContext {
        if (RangeUtil.isInRange(healthPercentile, 0f, 100f))
            this.healthPercentile = healthPercentile
        return this
    }

    fun setSessionStartTime(sessionStartTime: Int): SessionContext {
        this.sessionStartTime = sessionStartTime
        return this
    }

    fun setSessionDuration(sessionDuration: Int): SessionContext {
        this.sessionDuration = sessionDuration
        return this
    }

    fun setInGamePurchasesUSD(inGamePurchasesUSD: Float): SessionContext {
        if (RangeUtil.isInRange(inGamePurchasesUSD, 0f)) {
            this.inGamePurchasesUSD = inGamePurchasesUSD
        }
        return this
    }

}