/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import android.content.Context;
import android.os.Build;
import android.os.StatFs;
import com.vungle.ads.internal.util.Logger;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u0006J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000fJ\u0006\u0010\u0016\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000fJ\u0006\u0010\u001a\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/vungle/ads/internal/util/PathProvider;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "cleverCacheDir", "Ljava/io/File;", "getContext", "()Landroid/content/Context;", "downloadsDir", "jsDir", "vungleDir", "getAvailableBytes", "", "path", "", "getCleverCacheDir", "getDownloadDir", "getDownloadsDirForAd", "adId", "getJsAssetDir", "jsVersion", "getJsDir", "getSharedPrefsDir", "getUnclosedAdFile", "name", "getVungleDir", "Companion", "vungle-ads_release"})
public final class PathProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final File vungleDir;
    @NotNull
    private final File downloadsDir;
    @NotNull
    private final File jsDir;
    @NotNull
    private final File cleverCacheDir;
    @NotNull
    private static final String VUNGLE_FOLDER = "vungle_cache";
    @NotNull
    private static final String DOWNLOADS_FOLDER = "downloads";
    @NotNull
    private static final String JS_FOLDER = "js";
    @NotNull
    private static final String CLEVER_CACHE_FOLDER = "clever_cache";
    private static final long UNKNOWN_SIZE = -1L;

    public PathProvider(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.vungleDir = new File(Build.VERSION.SDK_INT >= 21 ? this.context.getNoBackupFilesDir() : this.context.getFilesDir(), VUNGLE_FOLDER);
        this.downloadsDir = new File(this.vungleDir, DOWNLOADS_FOLDER);
        this.jsDir = new File(this.vungleDir, JS_FOLDER);
        this.cleverCacheDir = new File(this.vungleDir, CLEVER_CACHE_FOLDER);
        Object[] objectArray = new File[]{this.vungleDir, this.downloadsDir, this.jsDir, this.cleverCacheDir};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.exists()) continue;
            it.mkdirs();
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final File getVungleDir() {
        if (!this.vungleDir.exists()) {
            this.vungleDir.mkdirs();
        }
        return this.vungleDir;
    }

    @NotNull
    public final File getCleverCacheDir() {
        if (!this.cleverCacheDir.exists()) {
            this.cleverCacheDir.mkdirs();
        }
        return this.cleverCacheDir;
    }

    @NotNull
    public final File getJsDir() {
        if (!this.jsDir.exists()) {
            this.jsDir.mkdirs();
        }
        return this.jsDir;
    }

    @NotNull
    public final File getDownloadDir() {
        if (!this.downloadsDir.exists()) {
            this.downloadsDir.mkdirs();
        }
        return this.downloadsDir;
    }

    @NotNull
    public final File getJsAssetDir(@NotNull String jsVersion) {
        Intrinsics.checkNotNullParameter((Object)jsVersion, (String)"jsVersion");
        File jsAssetDir = new File(this.getJsDir(), jsVersion);
        if (!jsAssetDir.exists()) {
            jsAssetDir.mkdirs();
        }
        return jsAssetDir;
    }

    @Nullable
    public final File getDownloadsDirForAd(@Nullable String adId) {
        CharSequence charSequence = adId;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        File downloadDirForAd = this.getDownloadDir();
        File adDir = new File(downloadDirForAd.getPath() + File.separator + adId);
        if (!adDir.exists()) {
            adDir.mkdirs();
        }
        return adDir;
    }

    @NotNull
    public final File getSharedPrefsDir() {
        File file;
        if (Build.VERSION.SDK_INT >= 21) {
            File file2 = this.context.getNoBackupFilesDir();
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"{\n        context.noBackupFilesDir\n    }");
        } else {
            File file3 = this.context.getFilesDir();
            file = file3;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"{\n        context.filesDir\n    }");
        }
        return file;
    }

    @NotNull
    public final File getUnclosedAdFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new File(this.getSharedPrefsDir(), name);
    }

    public final long getAvailableBytes(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        long bytesAvailable = -1L;
        StatFs stats = null;
        try {
            stats = new StatFs(path);
            bytesAvailable = Build.VERSION.SDK_INT >= 18 ? stats.getAvailableBytes() : (long)stats.getAvailableBlocks() * (long)stats.getBlockSize();
        }
        catch (IllegalArgumentException e2) {
            Logger.Companion.w("PathProvider", "Failed to get available bytes " + e2.getMessage());
        }
        return bytesAvailable;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/vungle/ads/internal/util/PathProvider$Companion;", "", "()V", "CLEVER_CACHE_FOLDER", "", "DOWNLOADS_FOLDER", "JS_FOLDER", "UNKNOWN_SIZE", "", "VUNGLE_FOLDER", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

