/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.load;

import com.vungle.ads.VungleAdSize;
import com.vungle.ads.internal.model.BidPayload;
import com.vungle.ads.internal.model.Placement;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/vungle/ads/internal/load/AdRequest;", "Ljava/io/Serializable;", "placement", "Lcom/vungle/ads/internal/model/Placement;", "adMarkup", "Lcom/vungle/ads/internal/model/BidPayload;", "requestAdSize", "Lcom/vungle/ads/VungleAdSize;", "(Lcom/vungle/ads/internal/model/Placement;Lcom/vungle/ads/internal/model/BidPayload;Lcom/vungle/ads/VungleAdSize;)V", "getAdMarkup", "()Lcom/vungle/ads/internal/model/BidPayload;", "getPlacement", "()Lcom/vungle/ads/internal/model/Placement;", "getRequestAdSize", "()Lcom/vungle/ads/VungleAdSize;", "equals", "", "other", "", "hashCode", "", "toString", "", "vungle-ads_release"})
public final class AdRequest
implements Serializable {
    @NotNull
    private final Placement placement;
    @Nullable
    private final BidPayload adMarkup;
    @Nullable
    private final VungleAdSize requestAdSize;

    public AdRequest(@NotNull Placement placement, @Nullable BidPayload adMarkup, @Nullable VungleAdSize requestAdSize) {
        Intrinsics.checkNotNullParameter((Object)placement, (String)"placement");
        this.placement = placement;
        this.adMarkup = adMarkup;
        this.requestAdSize = requestAdSize;
    }

    @NotNull
    public final Placement getPlacement() {
        return this.placement;
    }

    @Nullable
    public final BidPayload getAdMarkup() {
        return this.adMarkup;
    }

    @Nullable
    public final VungleAdSize getRequestAdSize() {
        return this.requestAdSize;
    }

    @NotNull
    public String toString() {
        return "AdRequest{placementId='" + this.placement.getReferenceId() + "', adMarkup=" + this.adMarkup + ", requestAdSize=" + this.requestAdSize + '}';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        AdRequest request = (AdRequest)other;
        if (!Intrinsics.areEqual((Object)this.placement.getReferenceId(), (Object)request.placement.getReferenceId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.requestAdSize, (Object)request.requestAdSize)) {
            return false;
        }
        return this.adMarkup != null ? Intrinsics.areEqual((Object)this.adMarkup, (Object)request.adMarkup) : request.adMarkup == null;
    }

    public int hashCode() {
        int result = this.placement.getReferenceId().hashCode();
        VungleAdSize vungleAdSize = this.requestAdSize;
        result = 31 * result + (vungleAdSize != null ? vungleAdSize.hashCode() : 0);
        BidPayload bidPayload = this.adMarkup;
        result = 31 * result + (bidPayload != null ? bidPayload.hashCode() : 0);
        return result;
    }
}

