/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\tJ\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006J\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/vungle/ads/internal/util/HandlerScheduler;", "", "()V", "handler", "Landroid/os/Handler;", "calculateTime", "", "delay", "cancel", "", "tag", "", "cancelAll", "schedule", "runnable", "Ljava/lang/Runnable;", "vungle-ads_release"})
public final class HandlerScheduler {
    @NotNull
    private final Handler handler = new Handler(Looper.getMainLooper());

    public final void schedule(@NotNull Runnable runnable, @NotNull String tag, long delay) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.handler.postAtTime(runnable, (Object)tag, this.calculateTime(delay));
    }

    private final long calculateTime(long delay) {
        return SystemClock.uptimeMillis() + delay;
    }

    public final void schedule(@NotNull Runnable runnable, long delay) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.handler.postAtTime(runnable, this.calculateTime(delay));
    }

    public final void cancel(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.handler.removeCallbacksAndMessages((Object)tag);
    }

    public final void cancelAll() {
        this.handler.removeCallbacksAndMessages(null);
    }
}

