/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.privacy;

import android.content.Context;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.privacy.COPPA;
import com.vungle.ads.internal.privacy.PrivacyConsent;
import com.vungle.ads.internal.util.Logger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\fJ\u0006\u0010\u0017\u001a\u00020\fJ\u0006\u0010\u0018\u001a\u00020\fJ\u0006\u0010\u0019\u001a\u00020\u0010J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0007H\u0002J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0007H\u0002J(\u0010&\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0010H\u0002J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u0007H\u0002J\u000e\u0010,\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u0007J\u0006\u0010-\u001a\u00020\u0007J\u000e\u0010.\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u0007J\u000e\u00101\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u0007J \u00102\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/vungle/ads/internal/privacy/PrivacyManager;", "", "()V", "ccpaConsent", "Lcom/vungle/ads/internal/privacy/PrivacyConsent;", "coppaStatus", "Ljava/util/concurrent/atomic/AtomicReference;", "", "disableAdId", "filePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "gdprConsent", "", "gdprConsentMessageVersion", "gdprConsentSource", "gdprConsentTimestamp", "", "Ljava/lang/Long;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "publishAndroidId", "getCcpaStatus", "getConsentMessageVersion", "getConsentSource", "getConsentStatus", "getConsentTimestamp", "getCoppaStatus", "Lcom/vungle/ads/internal/privacy/COPPA;", "getPublishAndroidId", "init", "", "context", "Landroid/content/Context;", "saveCcpaConsent", "consent", "saveCoppaConsent", "value", "saveDisableAdId", "saveGdprConsent", "source", "consentMessageVersion", "consentTimestamp", "savePublishAndroidId", "publish", "setPublishAndroidId", "shouldSendAdIds", "updateCcpaConsent", "updateCoppaConsent", "newValue", "updateDisableAdId", "updateGdprConsent", "vungle-ads_release"})
public final class PrivacyManager {
    @NotNull
    public static final PrivacyManager INSTANCE = new PrivacyManager();
    @NotNull
    private static final AtomicReference<Boolean> disableAdId = new AtomicReference();
    @NotNull
    private static final AtomicReference<Boolean> coppaStatus = new AtomicReference();
    @NotNull
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    @Nullable
    private static String gdprConsent;
    @Nullable
    private static String gdprConsentSource;
    @Nullable
    private static String gdprConsentMessageVersion;
    @Nullable
    private static Long gdprConsentTimestamp;
    @Nullable
    private static PrivacyConsent ccpaConsent;
    @NotNull
    private static AtomicReference<Boolean> publishAndroidId;
    @Nullable
    private static FilePreferences filePreferences;

    private PrivacyManager() {
    }

    public final synchronized void init(@NotNull Context context) {
        FilePreferences filePreferences;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (initialized.get()) {
            Logger.Companion.w("PrivacyManager", "PrivacyManager already initialized");
            return;
        }
        PrivacyManager.filePreferences = filePreferences = ServiceLocator.Companion.getInstance(context).getService(FilePreferences.class);
        Boolean disableAdIdFlag = disableAdId.get();
        if (disableAdIdFlag != null) {
            this.saveDisableAdId(disableAdIdFlag);
        } else {
            Boolean storedDisableAdId;
            Boolean bl = storedDisableAdId = filePreferences.getBoolean("disable_ad_id");
            if (bl != null) {
                boolean $this$init_u24lambda_u2d0 = bl;
                boolean bl2 = false;
                disableAdId.set($this$init_u24lambda_u2d0);
            }
        }
        String gdpr = gdprConsent;
        if (gdpr != null) {
            String string;
            String string2 = gdprConsentSource;
            if (string2 == null) {
                string2 = "";
            }
            if ((string = gdprConsentMessageVersion) == null) {
                string = "";
            }
            Long l = gdprConsentTimestamp;
            this.saveGdprConsent(gdpr, string2, string, l != null ? l : 0L);
        } else {
            String storedGdpr = filePreferences.getString("gdpr_status");
            String $this$init_u24lambda_u2d0 = storedGdpr;
            gdprConsent = Intrinsics.areEqual((Object)$this$init_u24lambda_u2d0, (Object)PrivacyConsent.OPT_IN.getValue()) ? PrivacyConsent.OPT_IN.getValue() : (Intrinsics.areEqual((Object)$this$init_u24lambda_u2d0, (Object)PrivacyConsent.OPT_OUT.getValue()) ? PrivacyConsent.OPT_OUT.getValue() : storedGdpr);
            gdprConsentSource = filePreferences.getString("gdpr_source");
            gdprConsentMessageVersion = filePreferences.getString("gdpr_message_version");
            gdprConsentTimestamp = filePreferences.getLong("gdpr_timestamp", 0L);
        }
        PrivacyConsent ccpaStatus = ccpaConsent;
        if (ccpaStatus != null) {
            this.saveCcpaConsent(ccpaStatus);
        } else {
            String storedCcpa = filePreferences.getString("ccpa_status");
            ccpaConsent = Intrinsics.areEqual((Object)PrivacyConsent.OPT_OUT.getValue(), (Object)storedCcpa) ? PrivacyConsent.OPT_OUT : PrivacyConsent.OPT_IN;
        }
        Boolean coppa = coppaStatus.get();
        if (coppa != null) {
            this.saveCoppaConsent(coppa);
        } else {
            Boolean storedCoppa;
            Boolean bl = storedCoppa = filePreferences.getBoolean("is_coppa");
            if (bl != null) {
                boolean $this$init_u24lambda_u2d1 = bl;
                boolean bl3 = false;
                coppaStatus.set($this$init_u24lambda_u2d1);
            }
        }
        Boolean publishAndroidIdFlag = publishAndroidId.get();
        if (publishAndroidIdFlag != null) {
            this.savePublishAndroidId(publishAndroidIdFlag);
        } else {
            Boolean storedPublishAndroidId;
            Boolean bl = storedPublishAndroidId = filePreferences.getBoolean("publish_android_id");
            if (bl != null) {
                boolean $this$init_u24lambda_u2d2 = bl;
                boolean bl4 = false;
                publishAndroidId.set($this$init_u24lambda_u2d2);
            }
        }
        initialized.set(true);
    }

    public final void updateGdprConsent(@NotNull String consent, @NotNull String source, @Nullable String consentMessageVersion) {
        Intrinsics.checkNotNullParameter((Object)consent, (String)"consent");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        gdprConsent = consent;
        gdprConsentSource = source;
        gdprConsentMessageVersion = consentMessageVersion;
        long gdprConsentTimestamp = System.currentTimeMillis() / (long)1000;
        PrivacyManager.gdprConsentTimestamp = gdprConsentTimestamp;
        String string = gdprConsentMessageVersion;
        if (string == null) {
            string = "";
        }
        this.saveGdprConsent(consent, source, string, gdprConsentTimestamp);
    }

    private final void saveGdprConsent(String consent, String source, String consentMessageVersion, long consentTimestamp) {
        block0: {
            FilePreferences filePreferences;
            FilePreferences filePreferences2;
            FilePreferences filePreferences3;
            FilePreferences filePreferences4;
            FilePreferences filePreferences5 = PrivacyManager.filePreferences;
            if (filePreferences5 == null || (filePreferences4 = filePreferences5.put("gdpr_status", consent)) == null || (filePreferences3 = filePreferences4.put("gdpr_source", source)) == null || (filePreferences2 = filePreferences3.put("gdpr_message_version", consentMessageVersion)) == null || (filePreferences = filePreferences2.put("gdpr_timestamp", consentTimestamp)) == null) break block0;
            filePreferences.apply();
        }
    }

    public final void updateCcpaConsent(@NotNull PrivacyConsent consent) {
        Intrinsics.checkNotNullParameter((Object)((Object)consent), (String)"consent");
        ccpaConsent = consent;
        this.saveCcpaConsent(consent);
    }

    @NotNull
    public final String getCcpaStatus() {
        Object object = ccpaConsent;
        if (object == null || (object = object.getValue()) == null) {
            object = PrivacyConsent.OPT_IN.getValue();
        }
        return object;
    }

    private final void saveCcpaConsent(PrivacyConsent consent) {
        block0: {
            FilePreferences filePreferences = PrivacyManager.filePreferences;
            if (filePreferences == null || (filePreferences = filePreferences.put("ccpa_status", consent.getValue())) == null) break block0;
            filePreferences.apply();
        }
    }

    public final void updateCoppaConsent(boolean newValue) {
        coppaStatus.set(newValue);
        this.saveCoppaConsent(newValue);
    }

    private final void saveCoppaConsent(boolean value) {
        block0: {
            FilePreferences filePreferences = PrivacyManager.filePreferences;
            if (filePreferences == null || (filePreferences = filePreferences.put("is_coppa", value)) == null) break block0;
            filePreferences.apply();
        }
    }

    public final void updateDisableAdId(boolean newValue) {
        disableAdId.set(newValue);
        this.saveDisableAdId(newValue);
    }

    private final void saveDisableAdId(boolean value) {
        block0: {
            FilePreferences filePreferences = PrivacyManager.filePreferences;
            if (filePreferences == null || (filePreferences = filePreferences.put("disable_ad_id", value)) == null) break block0;
            filePreferences.apply();
        }
    }

    @NotNull
    public final String getConsentStatus() {
        String string = gdprConsent;
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    @NotNull
    public final String getConsentSource() {
        String string = gdprConsentSource;
        if (string == null) {
            string = "no_interaction";
        }
        return string;
    }

    @NotNull
    public final String getConsentMessageVersion() {
        String string = gdprConsentMessageVersion;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final long getConsentTimestamp() {
        Long l = gdprConsentTimestamp;
        return l != null ? l : 0L;
    }

    @NotNull
    public final COPPA getCoppaStatus() {
        if (coppaStatus.get() == null) {
            return COPPA.COPPA_NOTSET;
        }
        if (Intrinsics.areEqual((Object)coppaStatus.get(), (Object)true)) {
            return COPPA.COPPA_ENABLED;
        }
        if (Intrinsics.areEqual((Object)coppaStatus.get(), (Object)false)) {
            return COPPA.COPPA_DISABLED;
        }
        return COPPA.COPPA_NOTSET;
    }

    public final boolean shouldSendAdIds() {
        Boolean value;
        Boolean bl = value = disableAdId.get();
        return bl == null ? false : bl == false;
    }

    public final void setPublishAndroidId(boolean publish) {
        publishAndroidId.set(publish);
        this.savePublishAndroidId(publish);
    }

    private final void savePublishAndroidId(boolean publish) {
        block0: {
            FilePreferences filePreferences = PrivacyManager.filePreferences;
            if (filePreferences == null || (filePreferences = filePreferences.put("publish_android_id", publish)) == null) break block0;
            filePreferences.apply();
        }
    }

    public final boolean getPublishAndroidId() {
        Boolean bl = publishAndroidId.get();
        return bl != null ? bl : true;
    }

    static {
        publishAndroidId = new AtomicReference();
    }
}

