/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.platform;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import androidx.core.util.Consumer;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.appset.AppSet;
import com.google.android.gms.appset.AppSetIdClient;
import com.google.android.gms.appset.AppSetIdInfo;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.tasks.Task;
import com.vungle.ads.internal.executor.VungleThreadPoolExecutor;
import com.vungle.ads.internal.model.AdvertisingInfo;
import com.vungle.ads.internal.platform.Platform;
import com.vungle.ads.internal.platform.WebViewUtil;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.util.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001f\u001a\u00020\bH\u0016J\n\u0010 \u001a\u0004\u0018\u00010\nH\u0017J\n\u0010!\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\"\u001a\u00020#2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0%H\u0016J\b\u0010&\u001a\u00020#H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\n8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006("}, d2={"Lcom/vungle/ads/internal/platform/AndroidPlatform;", "Lcom/vungle/ads/internal/platform/Platform;", "context", "Landroid/content/Context;", "uaExecutor", "Lcom/vungle/ads/internal/executor/VungleThreadPoolExecutor;", "(Landroid/content/Context;Lcom/vungle/ads/internal/executor/VungleThreadPoolExecutor;)V", "advertisingInfo", "Lcom/vungle/ads/internal/model/AdvertisingInfo;", "appSetId", "", "carrierName", "getCarrierName", "()Ljava/lang/String;", "isAtLeastMinimumSDK", "", "()Z", "isBatterySaverEnabled", "isSdCardPresent", "isSideLoaded", "isSoundEnabled", "powerManager", "Landroid/os/PowerManager;", "userAgent", "getUserAgent", "setUserAgent", "(Ljava/lang/String;)V", "volumeLevel", "", "getVolumeLevel", "()F", "getAdvertisingInfo", "getAndroidId", "getAppSetId", "getUserAgentLazy", "", "consumer", "Landroidx/core/util/Consumer;", "updateAppSetID", "Companion", "vungle-ads_release"})
public final class AndroidPlatform
implements Platform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final VungleThreadPoolExecutor uaExecutor;
    @Nullable
    private String appSetId;
    @Nullable
    private AdvertisingInfo advertisingInfo;
    @NotNull
    private final PowerManager powerManager;
    private final boolean isSideLoaded;
    @Nullable
    private String userAgent;
    @NotNull
    private static final String TAG = "AndroidPlatform";

    public AndroidPlatform(@NotNull Context context, @NotNull VungleThreadPoolExecutor uaExecutor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uaExecutor, (String)"uaExecutor");
        this.context = context;
        this.uaExecutor = uaExecutor;
        this.updateAppSetID();
        Object object = this.context.getSystemService("power");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
        this.powerManager = (PowerManager)object;
    }

    @Override
    public boolean isAtLeastMinimumSDK() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @Override
    public boolean isBatterySaverEnabled() {
        return Build.VERSION.SDK_INT >= 21 ? this.powerManager.isPowerSaveMode() : false;
    }

    @Override
    public boolean isSideLoaded() {
        return this.isSideLoaded;
    }

    @Override
    public float getVolumeLevel() {
        float f2;
        try {
            Object object = this.context.getSystemService("audio");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
            AudioManager audioManager = (AudioManager)object;
            float max = audioManager.getStreamMaxVolume(3);
            float current = audioManager.getStreamVolume(3);
            f2 = current / max;
        }
        catch (Exception _) {
            f2 = 0.0f;
        }
        return f2;
    }

    @Override
    public boolean isSoundEnabled() {
        boolean bl;
        try {
            Object object = this.context.getSystemService("audio");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
            AudioManager audioManager = (AudioManager)object;
            int current = audioManager.getStreamVolume(3);
            bl = current > 0;
        }
        catch (Exception _) {
            bl = true;
        }
        return bl;
    }

    @Override
    @NotNull
    public String getCarrierName() {
        String string = Companion.getCarrierName$vungle_ads_release(this.context);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCarrierName(context)");
        return string;
    }

    @Override
    public boolean isSdCardPresent() {
        boolean bl;
        try {
            bl = Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted");
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Acquiring external storage state failed", e2);
            bl = false;
        }
        return bl;
    }

    @Override
    public void getUserAgentLazy(@NotNull Consumer<String> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.uaExecutor.execute(() -> AndroidPlatform.getUserAgentLazy$lambda-0(this, consumer));
    }

    @Override
    @NotNull
    public AdvertisingInfo getAdvertisingInfo() {
        CharSequence charSequence;
        AdvertisingInfo cachedAdvInfo = this.advertisingInfo;
        if (cachedAdvInfo != null && !((charSequence = (CharSequence)cachedAdvInfo.getAdvertisingId()) == null || charSequence.length() == 0)) {
            return cachedAdvInfo;
        }
        AdvertisingInfo advertisingInfo = new AdvertisingInfo();
        try {
            AdvertisingIdClient.Info idInfo = null;
            if (Intrinsics.areEqual((Object)"Amazon", (Object)Build.MANUFACTURER)) {
                try {
                    ContentResolver cr = this.context.getContentResolver();
                    advertisingInfo.setLimitAdTracking(Settings.Secure.getInt((ContentResolver)cr, (String)"limit_ad_tracking") == 1);
                    advertisingInfo.setAdvertisingId(Settings.Secure.getString((ContentResolver)cr, (String)"advertising_id"));
                }
                catch (Settings.SettingNotFoundException ex) {
                    Logger.Companion.w(TAG, "Error getting Amazon advertising info", ex);
                }
            } else {
                try {
                    AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
                    Intrinsics.checkNotNullExpressionValue((Object)info, (String)"getAdvertisingIdInfo(context)");
                    idInfo = info;
                    advertisingInfo.setAdvertisingId(idInfo.getId());
                    advertisingInfo.setLimitAdTracking(idInfo.isLimitAdTrackingEnabled());
                }
                catch (NoClassDefFoundError ex) {
                    Logger.Companion.e(TAG, "Play services Not available: " + ex.getLocalizedMessage());
                    ContentResolver cr = this.context.getContentResolver();
                    advertisingInfo.setAdvertisingId(Settings.Secure.getString((ContentResolver)cr, (String)"advertising_id"));
                }
                catch (GooglePlayServicesNotAvailableException exception) {
                    Logger.Companion.e(TAG, "Play services Not available: " + exception.getLocalizedMessage());
                }
            }
        }
        catch (Exception ex) {
            Logger.Companion.e(TAG, "Cannot load Advertising ID");
        }
        this.advertisingInfo = advertisingInfo;
        return advertisingInfo;
    }

    @Override
    @Nullable
    public String getAppSetId() {
        return this.appSetId;
    }

    @Override
    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public String getAndroidId() {
        return PrivacyManager.INSTANCE.getPublishAndroidId() ? Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id") : "";
    }

    private final void updateAppSetID() {
        try {
            AppSetIdClient appSetIdClient = AppSet.getClient((Context)this.context);
            Intrinsics.checkNotNullExpressionValue((Object)appSetIdClient, (String)"getClient(context)");
            AppSetIdClient client = appSetIdClient;
            Task task = client.getAppSetIdInfo();
            Intrinsics.checkNotNullExpressionValue((Object)task, (String)"client.appSetIdInfo");
            Task task2 = task;
            task2.addOnSuccessListener(arg_0 -> AndroidPlatform.updateAppSetID$lambda-1(this, arg_0));
        }
        catch (NoClassDefFoundError ex) {
            Logger.Companion.e(TAG, "Required libs to get AppSetID Not available: " + ex.getLocalizedMessage());
        }
    }

    @Override
    @Nullable
    public String getUserAgent() {
        String string = this.userAgent;
        if (string == null) {
            string = System.getProperty("http.agent");
        }
        return string;
    }

    public void setUserAgent(@Nullable String string) {
        this.userAgent = string;
    }

    private static final void getUserAgentLazy$lambda-0(AndroidPlatform this$0, Consumer $consumer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
        new WebViewUtil(this$0.context).getUserAgent((Consumer<String>)$consumer);
    }

    private static final void updateAppSetID$lambda-1(AndroidPlatform this$0, AppSetIdInfo info) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (info != null) {
            this$0.appSetId = info.getId();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/vungle/ads/internal/platform/AndroidPlatform$Companion;", "", "()V", "TAG", "", "getCarrierName", "kotlin.jvm.PlatformType", "context", "Landroid/content/Context;", "getCarrierName$vungle_ads_release", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public final String getCarrierName$vungle_ads_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = context.getSystemService("phone");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
            return ((TelephonyManager)object).getNetworkOperatorName();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

