/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.PermissionChecker;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.ConfigurationError;
import com.vungle.ads.ConfigurationResponseError;
import com.vungle.ads.InitializationListener;
import com.vungle.ads.InvalidAppId;
import com.vungle.ads.Metric;
import com.vungle.ads.NetworkPermissionsNotGranted;
import com.vungle.ads.NetworkUnreachable;
import com.vungle.ads.OutOfMemory;
import com.vungle.ads.SdkAlreadyInitialized;
import com.vungle.ads.SdkInitializationInProgress;
import com.vungle.ads.SdkNotInitialized;
import com.vungle.ads.SdkVersionTooLow;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.TimeIntervalMetric;
import com.vungle.ads.UnknownConfigurationError;
import com.vungle.ads.VungleError;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.downloader.Downloader;
import com.vungle.ads.internal.executor.Executors;
import com.vungle.ads.internal.load.MraidJsLoader;
import com.vungle.ads.internal.model.ConfigPayload;
import com.vungle.ads.internal.network.Call;
import com.vungle.ads.internal.network.Response;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.omsdk.OMInjector;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.platform.Platform;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.signals.SignalManager;
import com.vungle.ads.internal.task.CleanupJob;
import com.vungle.ads.internal.task.JobRunner;
import com.vungle.ads.internal.task.ResendTpatJob;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import com.vungle.ads.internal.util.ThreadUtil;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\r\u0010\u0019\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001aJ\u001e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0018J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u00020\u00068\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u00020\r8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006&\u00b2\u0006\n\u0010'\u001a\u00020(X\u008a\u0084\u0002\u00b2\u0006\n\u0010)\u001a\u00020*X\u008a\u0084\u0002\u00b2\u0006\n\u0010+\u001a\u00020,X\u008a\u0084\u0002\u00b2\u0006\n\u0010+\u001a\u00020,X\u008a\u0084\u0002\u00b2\u0006\n\u0010)\u001a\u00020*X\u008a\u0084\u0002\u00b2\u0006\n\u0010-\u001a\u00020.X\u008a\u0084\u0002\u00b2\u0006\n\u0010/\u001a\u000200X\u008a\u0084\u0002\u00b2\u0006\n\u00101\u001a\u000202X\u008a\u0084\u0002\u00b2\u0006\n\u00103\u001a\u000204X\u008a\u0084\u0002\u00b2\u0006\n\u00105\u001a\u000206X\u008a\u0084\u0002\u00b2\u0006\n\u00107\u001a\u000208X\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/VungleInitializer;", "", "()V", "initRequestToResponseMetric", "Lcom/vungle/ads/TimeIntervalMetric;", "isInitialized", "", "isInitialized$vungle_ads_release$annotations", "isInitialized$vungle_ads_release", "()Z", "setInitialized$vungle_ads_release", "(Z)V", "isInitializing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isInitializing$vungle_ads_release$annotations", "isInitializing$vungle_ads_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "setInitializing$vungle_ads_release", "(Ljava/util/concurrent/atomic/AtomicBoolean;)V", "configure", "", "context", "Landroid/content/Context;", "callback", "Lcom/vungle/ads/InitializationListener;", "deInit", "deInit$vungle_ads_release", "init", "appId", "", "initializationCallback", "isAppIdInvalid", "onInitError", "initCallback", "exception", "Lcom/vungle/ads/VungleError;", "onInitSuccess", "Companion", "vungle-ads_release", "platform", "Lcom/vungle/ads/internal/platform/Platform;", "sdkExecutors", "Lcom/vungle/ads/internal/executor/Executors;", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "signalManager", "Lcom/vungle/ads/internal/signals/SignalManager;", "filePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "omInjector", "Lcom/vungle/ads/internal/omsdk/OMInjector;", "jobRunner", "Lcom/vungle/ads/internal/task/JobRunner;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "downloader", "Lcom/vungle/ads/internal/downloader/Downloader;"})
public final class VungleInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isInitialized;
    @NotNull
    private AtomicBoolean isInitializing = new AtomicBoolean(false);
    @NotNull
    private TimeIntervalMetric initRequestToResponseMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.INIT_REQUEST_TO_RESPONSE_DURATION_MS);
    @NotNull
    private static final String TAG = "VungleInitializer";

    public final boolean isInitialized$vungle_ads_release() {
        return this.isInitialized;
    }

    public final void setInitialized$vungle_ads_release(boolean bl) {
        this.isInitialized = bl;
    }

    @VisibleForTesting
    public static /* synthetic */ void isInitialized$vungle_ads_release$annotations() {
    }

    @NotNull
    public final AtomicBoolean isInitializing$vungle_ads_release() {
        return this.isInitializing;
    }

    public final void setInitializing$vungle_ads_release(@NotNull AtomicBoolean atomicBoolean) {
        Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
        this.isInitializing = atomicBoolean;
    }

    @VisibleForTesting
    public static /* synthetic */ void isInitializing$vungle_ads_release$annotations() {
    }

    public final void init(@NotNull String appId, @NotNull Context context, @NotNull InitializationListener initializationCallback) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)initializationCallback, (String)"initializationCallback");
        if (this.isAppIdInvalid(appId)) {
            this.onInitError(initializationCallback, new InvalidAppId().logError$vungle_ads_release());
            return;
        }
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        boolean $i$f$inject = false;
        Lazy platform$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Platform>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Platform invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(Platform.class);
            }
        }));
        if (!VungleInitializer.init$lambda-0((Lazy<? extends Platform>)platform$delegate).isAtLeastMinimumSDK()) {
            Logger.Companion.e(TAG, "SDK is supported only for API versions 21 and above");
            this.onInitError(initializationCallback, new SdkVersionTooLow().logError$vungle_ads_release());
            return;
        }
        if (this.isInitialized()) {
            Logger.Companion.d(TAG, "init already complete");
            new SdkAlreadyInitialized().logErrorNoReturnValue$vungle_ads_release();
            this.onInitSuccess(initializationCallback);
            return;
        }
        if (this.isInitializing.getAndSet(true)) {
            Logger.Companion.d(TAG, "init ongoing");
            this.onInitError(initializationCallback, new SdkInitializationInProgress().logError$vungle_ads_release());
            return;
        }
        if (PermissionChecker.checkCallingOrSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") != 0 || PermissionChecker.checkCallingOrSelfPermission((Context)context, (String)"android.permission.INTERNET") != 0) {
            Logger.Companion.e(TAG, "Network permissions not granted");
            this.onInitError(initializationCallback, new NetworkPermissionsNotGranted());
            return;
        }
        ServiceLocator.Companion this_$iv2 = ServiceLocator.Companion;
        boolean $i$f$inject2 = false;
        Lazy sdkExecutors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Executors>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Executors invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(Executors.class);
            }
        }));
        ServiceLocator.Companion this_$iv3 = ServiceLocator.Companion;
        boolean $i$f$inject3 = false;
        Lazy vungleApiClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<VungleApiClient>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final VungleApiClient invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(VungleApiClient.class);
            }
        }));
        VungleInitializer.init$lambda-1((Lazy<? extends Executors>)sdkExecutors$delegate).getBackgroundExecutor().execute(() -> VungleInitializer.init$lambda-3(context, appId, this, initializationCallback, vungleApiClient$delegate), () -> VungleInitializer.init$lambda-4(this, initializationCallback));
    }

    private final boolean isAppIdInvalid(String appId) {
        return StringsKt.isBlank((CharSequence)appId);
    }

    private final void configure(Context context, InitializationListener callback2) {
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        boolean $i$f$inject = false;
        Lazy vungleApiClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<VungleApiClient>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final VungleApiClient invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(VungleApiClient.class);
            }
        }));
        try {
            boolean $i$f$inject2;
            ServiceLocator.Companion this_$iv2;
            ConfigPayload configPayload;
            Response<ConfigPayload> response;
            this.initRequestToResponseMetric.markStart();
            Call<ConfigPayload> call = VungleInitializer.configure$lambda-5((Lazy<VungleApiClient>)vungleApiClient$delegate).config();
            Response<ConfigPayload> response2 = response = call != null ? call.execute() : null;
            if (response == null) {
                this.onInitError(callback2, new SdkNotInitialized().logError$vungle_ads_release());
                return;
            }
            if (!response.isSuccessful()) {
                this.onInitError(callback2, new ConfigurationError().logError$vungle_ads_release());
                return;
            }
            this.initRequestToResponseMetric.markEnd();
            ConfigPayload configPayload2 = configPayload = response.body();
            if ((configPayload2 != null ? configPayload2.getEndpoints() : null) == null) {
                this.onInitError(callback2, new ConfigurationResponseError().logError$vungle_ads_release());
                return;
            }
            ConfigManager.INSTANCE.initWithConfig(configPayload);
            ServiceLocator.Companion this_$iv3 = ServiceLocator.Companion;
            boolean $i$f$inject3 = false;
            Lazy sdkExecutors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Executors>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final Executors invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(Executors.class);
                }
            }));
            ServiceLocator.Companion this_$iv4 = ServiceLocator.Companion;
            boolean $i$f$inject4 = false;
            Lazy signalManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<SignalManager>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final SignalManager invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(SignalManager.class);
                }
            }));
            AnalyticsClient.INSTANCE.init$vungle_ads_release(VungleInitializer.configure$lambda-5((Lazy<VungleApiClient>)vungleApiClient$delegate), VungleInitializer.configure$lambda-6((Lazy<? extends Executors>)sdkExecutors$delegate).getLoggerExecutor(), ConfigManager.INSTANCE.getLogLevel(), ConfigManager.INSTANCE.getMetricsEnabled(), VungleInitializer.configure$lambda-7((Lazy<SignalManager>)signalManager$delegate));
            boolean valid = ConfigManager.INSTANCE.validateEndpoints();
            if (!valid) {
                this.onInitError(callback2, new ConfigurationError());
                return;
            }
            ServiceLocator.Companion this_$iv5 = ServiceLocator.Companion;
            boolean $i$f$inject5 = false;
            Lazy filePreferences$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<FilePreferences>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final FilePreferences invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(FilePreferences.class);
                }
            }));
            String it = configPayload.getConfigExtension();
            boolean bl = false;
            ConfigManager.INSTANCE.updateConfigExtension(it);
            CharSequence charSequence = it;
            if (charSequence == null || charSequence.length() == 0) {
                VungleInitializer.configure$lambda-8((Lazy<FilePreferences>)filePreferences$delegate).remove("config_extension").apply();
            } else {
                VungleInitializer.configure$lambda-8((Lazy<FilePreferences>)filePreferences$delegate).put("config_extension", it).apply();
            }
            if (ConfigManager.INSTANCE.omEnabled()) {
                this_$iv2 = ServiceLocator.Companion;
                $i$f$inject2 = false;
                Lazy omInjector$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<OMInjector>(context){
                    final /* synthetic */ Context $context;
                    {
                        this.$context = $context;
                        super(0);
                    }

                    @NotNull
                    public final OMInjector invoke() {
                        return ServiceLocator.Companion.getInstance(this.$context).getService(OMInjector.class);
                    }
                }));
                VungleInitializer.configure$lambda-10((Lazy<OMInjector>)omInjector$delegate).init();
            }
            if (ConfigManager.INSTANCE.placements() == null) {
                this.onInitError(callback2, new ConfigurationError());
                return;
            }
            PrivacyManager.INSTANCE.updateDisableAdId(ConfigManager.INSTANCE.shouldDisableAdId());
            this_$iv2 = ServiceLocator.Companion;
            $i$f$inject2 = false;
            Lazy jobRunner$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<JobRunner>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final JobRunner invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(JobRunner.class);
                }
            }));
            VungleInitializer.configure$lambda-11((Lazy<? extends JobRunner>)jobRunner$delegate).execute(CleanupJob.Companion.makeJobInfo$default(CleanupJob.Companion, null, 1, null));
            VungleInitializer.configure$lambda-11((Lazy<? extends JobRunner>)jobRunner$delegate).execute(ResendTpatJob.Companion.makeJobInfo());
            this.isInitialized = true;
            this.onInitSuccess(callback2);
            ServiceLocator.Companion this_$iv6 = ServiceLocator.Companion;
            boolean $i$f$inject6 = false;
            Lazy pathProvider$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<PathProvider>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final PathProvider invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(PathProvider.class);
                }
            }));
            ServiceLocator.Companion this_$iv7 = ServiceLocator.Companion;
            boolean $i$f$inject7 = false;
            Lazy downloader$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Downloader>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final Downloader invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(Downloader.class);
                }
            }));
            MraidJsLoader.downloadJs$default(MraidJsLoader.INSTANCE, VungleInitializer.configure$lambda-12((Lazy<PathProvider>)pathProvider$delegate), VungleInitializer.configure$lambda-13((Lazy<? extends Downloader>)downloader$delegate), VungleInitializer.configure$lambda-6((Lazy<? extends Executors>)sdkExecutors$delegate).getBackgroundExecutor(), null, 8, null);
        }
        catch (Throwable throwable) {
            this.isInitialized = false;
            Logger.Companion.e(TAG, "Cannot finish init", throwable);
            Throwable throwable2 = throwable;
            if (throwable2 instanceof UnknownHostException ? true : throwable2 instanceof SecurityException) {
                this.onInitError(callback2, new NetworkUnreachable().logError$vungle_ads_release());
            }
            if (throwable2 instanceof VungleError) {
                this.onInitError(callback2, (VungleError)throwable);
            }
            this.onInitError(callback2, new UnknownConfigurationError().logError$vungle_ads_release());
        }
    }

    private final void onInitError(InitializationListener initCallback, VungleError exception) {
        this.isInitializing.set(false);
        ThreadUtil.INSTANCE.runOnUiThread(() -> VungleInitializer.onInitError$lambda-14(initCallback, exception));
        String string = exception.getLocalizedMessage();
        if (string == null) {
            string = "Exception code is " + exception.getCode();
        }
        String exMsg = string;
        Logger.Companion.e(TAG, exMsg);
    }

    private final void onInitSuccess(InitializationListener initCallback) {
        this.isInitializing.set(false);
        ThreadUtil.INSTANCE.runOnUiThread(() -> VungleInitializer.onInitSuccess$lambda-15(initCallback));
        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, (Metric)this.initRequestToResponseMetric, null, null, null, VungleApiClient.Companion.getBASE_URL$vungle_ads_release(), 14, null);
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    public final void deInit$vungle_ads_release() {
        ServiceLocator.Companion.deInit();
        VungleApiClient.Companion.reset$vungle_ads_release();
        this.isInitialized = false;
        this.isInitializing.set(false);
    }

    private static final Platform init$lambda-0(Lazy<? extends Platform> $platform$delegate) {
        Lazy<? extends Platform> lazy = $platform$delegate;
        return (Platform)lazy.getValue();
    }

    private static final Executors init$lambda-1(Lazy<? extends Executors> $sdkExecutors$delegate) {
        Lazy<? extends Executors> lazy = $sdkExecutors$delegate;
        return (Executors)lazy.getValue();
    }

    private static final VungleApiClient init$lambda-2(Lazy<VungleApiClient> $vungleApiClient$delegate) {
        Lazy<VungleApiClient> lazy = $vungleApiClient$delegate;
        return (VungleApiClient)lazy.getValue();
    }

    private static final void init$lambda-3(Context $context, String $appId, VungleInitializer this$0, InitializationListener $initializationCallback, Lazy $vungleApiClient$delegate) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$appId, (String)"$appId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$initializationCallback, (String)"$initializationCallback");
        Intrinsics.checkNotNullParameter((Object)$vungleApiClient$delegate, (String)"$vungleApiClient$delegate");
        PrivacyManager.INSTANCE.init($context);
        VungleInitializer.init$lambda-2((Lazy<VungleApiClient>)$vungleApiClient$delegate).initialize($appId);
        this$0.configure($context, $initializationCallback);
    }

    private static final void init$lambda-4(VungleInitializer this$0, InitializationListener $initializationCallback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$initializationCallback, (String)"$initializationCallback");
        this$0.onInitError($initializationCallback, new OutOfMemory("Config: Out of Memory").logError$vungle_ads_release());
    }

    private static final VungleApiClient configure$lambda-5(Lazy<VungleApiClient> $vungleApiClient$delegate) {
        Lazy<VungleApiClient> lazy = $vungleApiClient$delegate;
        return (VungleApiClient)lazy.getValue();
    }

    private static final Executors configure$lambda-6(Lazy<? extends Executors> $sdkExecutors$delegate) {
        Lazy<? extends Executors> lazy = $sdkExecutors$delegate;
        return (Executors)lazy.getValue();
    }

    private static final SignalManager configure$lambda-7(Lazy<SignalManager> $signalManager$delegate) {
        Lazy<SignalManager> lazy = $signalManager$delegate;
        return (SignalManager)lazy.getValue();
    }

    private static final FilePreferences configure$lambda-8(Lazy<FilePreferences> $filePreferences$delegate) {
        Lazy<FilePreferences> lazy = $filePreferences$delegate;
        return (FilePreferences)lazy.getValue();
    }

    private static final OMInjector configure$lambda-10(Lazy<OMInjector> $omInjector$delegate) {
        Lazy<OMInjector> lazy = $omInjector$delegate;
        return (OMInjector)lazy.getValue();
    }

    private static final JobRunner configure$lambda-11(Lazy<? extends JobRunner> $jobRunner$delegate) {
        Lazy<? extends JobRunner> lazy = $jobRunner$delegate;
        return (JobRunner)lazy.getValue();
    }

    private static final PathProvider configure$lambda-12(Lazy<PathProvider> $pathProvider$delegate) {
        Lazy<PathProvider> lazy = $pathProvider$delegate;
        return (PathProvider)lazy.getValue();
    }

    private static final Downloader configure$lambda-13(Lazy<? extends Downloader> $downloader$delegate) {
        Lazy<? extends Downloader> lazy = $downloader$delegate;
        return (Downloader)lazy.getValue();
    }

    private static final void onInitError$lambda-14(InitializationListener $initCallback, VungleError $exception) {
        Intrinsics.checkNotNullParameter((Object)$initCallback, (String)"$initCallback");
        Intrinsics.checkNotNullParameter((Object)$exception, (String)"$exception");
        $initCallback.onError($exception);
    }

    private static final void onInitSuccess$lambda-15(InitializationListener $initCallback) {
        Intrinsics.checkNotNullParameter((Object)$initCallback, (String)"$initCallback");
        Logger.Companion.d(TAG, "onSuccess");
        $initCallback.onSuccess();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vungle/ads/internal/VungleInitializer$Companion;", "", "()V", "TAG", "", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

