package com.voxeet.push.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.google.firebase.messaging.RemoteMessage;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class VoxeetManageRemoteMessage {

    public static boolean manageRemoteMessage(@NonNull Context context, @NonNull RemoteMessage remoteMessage) {
        Object voxeetSdkInstance = getVoxeetInstance();
        if (null != voxeetSdkInstance) {
            try {
                Method manageRemoteMessage = voxeetSdkInstance.getClass().getDeclaredMethod("manageRemoteMessage",
                        Context.class,
                        Map.class);
                return (boolean) manageRemoteMessage.invoke(voxeetSdkInstance, context, remoteMessage.getData());
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Nullable
    private static Object getVoxeetInstance() {
        try {
            Class klass = Class.forName("com.voxeet.sdk.core.VoxeetSdk");
            Method getInstance = klass.getDeclaredMethod("getInstance");
            return getInstance.invoke(null);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}
