/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.utils.converter;

import android.support.annotation.NonNull;
import com.google.gson.annotations.SerializedName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import retrofit2.Converter;
import retrofit2.Retrofit;

public final class EnumConverterFactory
extends Converter.Factory {
    public static EnumConverterFactory create() {
        return new EnumConverterFactory();
    }

    public Converter<?, String> stringConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        Converter converter = null;
        if (type instanceof Class && ((Class)type).isEnum()) {
            converter = value -> this.getSerializedNameValue((Enum)value);
        }
        return converter;
    }

    @NonNull
    private <E extends Enum<E>> String getSerializedNameValue(E e) {
        String value = null;
        try {
            value = e.getClass().getField(e.name()).getAnnotation(SerializedName.class).value();
        }
        catch (NoSuchFieldException exception) {
            exception.printStackTrace();
        }
        if (null == value) {
            return e.toString();
        }
        return value;
    }
}

