/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.utils;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.ViewConfiguration;
import android.view.WindowManager;

public class ScreenHelper {
    public static int actionBar(Context context) {
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(new int[]{16843499});
        int mActionBarSize = (int)styledAttributes.getDimension(0, 0.0f);
        styledAttributes.recycle();
        return mActionBarSize;
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static Point getScreenSize(@NonNull Context context) {
        try {
            Point size = new Point();
            Display d = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            DisplayMetrics realDisplayMetrics = new DisplayMetrics();
            if (Build.VERSION.SDK_INT >= 17) {
                d.getRealMetrics(realDisplayMetrics);
                size.x = realDisplayMetrics.widthPixels;
                size.y = realDisplayMetrics.heightPixels;
            } else {
                d.getSize(size);
            }
            return size;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Point();
        }
    }

    public static boolean hasSoftKeys(@NonNull Context context) {
        boolean hasSoftwareKeys = true;
        if (Build.VERSION.SDK_INT >= 21) {
            Display d = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            DisplayMetrics realDisplayMetrics = new DisplayMetrics();
            d.getRealMetrics(realDisplayMetrics);
            int realHeight = realDisplayMetrics.heightPixels;
            int realWidth = realDisplayMetrics.widthPixels;
            DisplayMetrics displayMetrics = new DisplayMetrics();
            d.getMetrics(displayMetrics);
            int displayHeight = displayMetrics.heightPixels;
            int displayWidth = displayMetrics.widthPixels;
            hasSoftwareKeys = realWidth - displayWidth > 0 || realHeight - displayHeight > 0;
        } else {
            boolean hasMenuKey = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
            boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
            hasSoftwareKeys = !hasMenuKey && !hasBackKey;
        }
        return hasSoftwareKeys;
    }

    public static Rect resolveNavigationBarDimenIssueAboveLollipop(@NonNull Context context) {
        Rect rect = new Rect(0, 0, 0, 0);
        if (Build.VERSION.SDK_INT >= 21) {
            WindowManager manager = (WindowManager)context.getSystemService("window");
            switch (manager.getDefaultDisplay().getRotation()) {
                case 1: {
                    rect.right += ScreenHelper.getNavBarWidth(context);
                    break;
                }
                case 2: {
                    rect.top += ScreenHelper.getNavBarHeight(context);
                    break;
                }
                case 3: {
                    rect.left += ScreenHelper.getNavBarWidth(context);
                    break;
                }
                default: {
                    rect.bottom += ScreenHelper.getNavBarHeight(context);
                }
            }
        }
        return rect;
    }

    private static int getNavBarWidth(@NonNull Context context) {
        return ScreenHelper.getNavBarDimen(context, "navigation_bar_width");
    }

    private static int getNavBarHeight(@NonNull Context context) {
        return ScreenHelper.getNavBarDimen(context, "navigation_bar_height");
    }

    private static int getNavBarDimen(@NonNull Context context, String resourceString) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier(resourceString, "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }
}

