/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.ServerErrorException;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class HttpHelper {
    private HttpHelper() {
    }

    @NonNull
    public static Throwable manageThrowableOrServerError(@NonNull Throwable throwable, @NonNull ServerErrorOrigin origin) {
        if (throwable instanceof HttpException) {
            try {
                throw new ServerErrorException(((HttpException)throwable).error, origin);
            }
            catch (Throwable thrown) {
                return thrown;
            }
        }
        ExceptionManager.sendException(throwable);
        return throwable;
    }

    public static <T> Promise<HttpAnswer<T>> promise(Call<T> call, @NonNull ServerErrorOrigin originForPossibleError) {
        return new Promise(solver -> HttpHelper.enqueue(call, (response, object, exception) -> {
            if (null != exception) {
                if (null != response) {
                    Log.d((String)"HttpHelper", (String)(response.message() + " " + response.code()));
                }
                exception.printStackTrace();
                Promise.reject((Solver)solver, (Throwable)HttpHelper.manageThrowableOrServerError(exception, originForPossibleError));
            } else {
                solver.resolve(new HttpAnswer<Object>(object, response));
            }
        }));
    }

    public static <T> void enqueue(Call<T> call, final @NonNull HttpCallback<T> callback) {
        call.enqueue(new Callback<T>(){

            public void onResponse(@NonNull Call<T> call, @NonNull Response<T> response) {
                if (response.isSuccessful()) {
                    callback.onResult(response, response.body(), null);
                } else {
                    callback.onResult(response, null, HttpException.throwResponse(response));
                }
            }

            public void onFailure(@NonNull Call<T> call, @NonNull Throwable t) {
                callback.onResult(null, null, t);
            }
        });
    }

    public static interface HttpCallback<T> {
        public void onResult(@Nullable Response<T> var1, @Nullable T var2, @Nullable Throwable var3);
    }

    public static class HttpAnswer<T> {
        public T object;
        public Response<T> response;

        public HttpAnswer(T object, Response<T> response) {
            this.object = object;
            this.response = response;
        }
    }
}

