/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.utils;

import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.VoxeetSDK;
import com.voxeet.android.media.MediaStream;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.json.ParticipantUpdated;
import com.voxeet.sdk.models.Participant;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public abstract class EventCallback {
    private static final String TAG = EventCallback.class.getSimpleName();

    public void register(VoxeetSDK template) {
        EventBus eventBus = template.getEventBus();
        try {
            if (!eventBus.isRegistered((Object)this)) {
                eventBus.register((Object)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregister(VoxeetSDK template) {
        EventBus eventBus = template.getEventBus();
        try {
            if (eventBus.isRegistered((Object)this)) {
                eventBus.unregister((Object)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPush event) {
        this.onConferenceDestroyed(event.conferenceId);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantUpdated event) {
        Log.d((String)TAG, (String)("onEvent: ParticipantUpdated " + event + " " + event.participantId + " " + event.status + " " + event.conferenceId));
        this.onParticipantUpdated(event.conferenceId, event.participantId, event.status);
    }

    protected abstract void onConferenceDestroyed(String var1);

    protected abstract void onParticipantUpdated(String var1, String var2, String var3);

    protected abstract void onParticipantLeft(@NonNull Participant var1);

    protected abstract void onParticipantJoined(@NonNull Participant var1, MediaStream var2);

    protected abstract void onParticipantUpdated(@NonNull Participant var1, MediaStream var2);

    protected abstract void onScreenAdded(String var1, MediaStream var2);

    protected abstract void onScreenRemoved(String var1);
}

