/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.telemetry.device;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.Display;
import android.view.WindowManager;
import com.voxeet.sdk.utils.Map;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.TimeZone;

public class HardwareInfo {
    private static final String[] EXPECTED = new String[]{"model_name", "cpu_model", "hardware"};
    private final long ram;
    private final Point screen;

    public HardwareInfo(@NonNull Context context) {
        ActivityManager actManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
        actManager.getMemoryInfo(memInfo);
        this.ram = memInfo.totalMem;
        WindowManager window = (WindowManager)context.getSystemService("window");
        Display display = window.getDefaultDisplay();
        this.screen = new Point();
        display.getSize(this.screen);
    }

    public long ram() {
        return this.ram;
    }

    public long width() {
        return this.screen.x;
    }

    public long height() {
        return this.screen.y;
    }

    public String deviceName() {
        return Build.DEVICE;
    }

    public String tz() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getDisplayName(true, 0).replace("GMT", "UTC");
    }

    public String cpu() {
        String cpu_name = "";
        try {
            String str;
            BufferedReader br = new BufferedReader(new FileReader("/proc/cpuinfo"));
            while ((str = br.readLine()) != null) {
                String key;
                String[] data = str.split(":");
                if (data.length <= 1 || !Map.isInInsensitive((String)(key = data[0].trim().replace(" ", "_")), (String[])EXPECTED)) continue;
                String value = data[1].trim();
                cpu_name = value.replaceAll("\\s+", " ");
            }
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cpu_name;
    }

    public String os() {
        return "android " + Build.VERSION.SDK_INT;
    }

    public String osName() {
        return "android";
    }

    public long version() {
        return Build.VERSION.SDK_INT;
    }
}

