/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.telemetry.codec;

import android.media.MediaCodecInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.utils.Map;
import com.voxeet.sdk.utils.Opt;
import java.util.ArrayList;
import java.util.List;
import org.webrtc.MediaCodecVideoHelperFactory;

public class Codec {
    @NonNull
    public String name;
    public boolean encoder;
    @Nullable
    public String mime;

    public Codec(@NonNull String name, boolean encoder, @Nullable List<String> mimes) {
        this.name = name;
        this.encoder = encoder;
        this.mime = (String)Opt.of(mimes).then(c -> c.size() > 0 ? (String)c.get(0) : null).orNull();
    }

    public static List<Codec> list() {
        try {
            ArrayList list = MediaCodecVideoHelperFactory.getCodecs();
            if (Build.VERSION.SDK_INT >= 16) {
                return Map.map((List)list, codecInfo -> {
                    List capabilities = Map.map((Object[])codecInfo.getSupportedTypes(), arg_0 -> ((MediaCodecInfo)codecInfo).getCapabilitiesForType(arg_0));
                    capabilities = Map.filter((List)capabilities, s -> null != s);
                    if (Build.VERSION.SDK_INT >= 21) {
                        return new Codec(codecInfo.getName(), codecInfo.isEncoder(), Map.map((List)capabilities, MediaCodecInfo.CodecCapabilities::getMimeType));
                    }
                    return new Codec(codecInfo.getName(), codecInfo.isEncoder(), null);
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

