/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiRecording;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;

public class StartRecordingPromiseable
extends AbstractPromiseable<Boolean, IRestApiRecording> {
    public StartRecordingPromiseable(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiRecording provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise(solver -> {
            ConferenceInformation information = this.getInformation();
            if (null == information || null == Opt.of((Object)information.getConference()).then(Conference::getId).orNull()) {
                Promise.reject((Solver)solver, (Throwable)new NotInConferenceException());
                return;
            }
            Call<ResponseBody> call = ((IRestApiRecording)this.getApiRestCall()).startRecording(information.getConference().getId());
            HttpHelper.promise(call, ServerErrorOrigin.START_RECORDING).then(answer -> solver.resolve((Object)this.is200(answer.response))).error(arg_0 -> ((Solver)solver).reject(arg_0));
        });
    }
}

