/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.sdk.ConferenceStatusUpdatedEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiConferenceAccess;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.information.ConferenceStatus;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class LeavePromise
extends AbstractPromiseable<Boolean, IRestApiConferenceAccess> {
    private static final String TAG = LeavePromise.class.getSimpleName();

    public LeavePromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiConferenceAccess provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise(solver -> {
            ConferenceInformation infos = this.getInformation();
            if (null == infos) {
                Promise.reject((Solver)solver, (Throwable)new NotInConferenceException());
                return;
            }
            Conference conference = infos.getConference();
            String conferenceId = infos.getConference().getId();
            infos.setConferenceState(ConferenceStatus.LEAVING);
            this.log("Attempting to leave mConference with mConference id " + conferenceId);
            this.closeMedia();
            Call<ResponseBody> user = ((IRestApiConferenceAccess)this.getApiRestCall()).leave(conferenceId);
            HttpHelper.promise(user, ServerErrorOrigin.LEAVE).then(answer -> {
                Log.d((String)"ConferenceService", (String)("Conference left successfully " + Opt.of((Object)answer).then(a -> a.response).then(Response::code).or((Object)0)));
                this.removeTimeoutCallbacks();
                infos.setConferenceState(ConferenceStatus.LEFT);
                this.getEventBus().post((Object)new ConferenceStatusUpdatedEvent(conference, conference.getState()));
                solver.resolve((Object)true);
            }).error(error -> {
                Log.d((String)TAG, (String)"Something went wrong while leaving the mConference");
                this.removeTimeoutCallbacks();
                infos.setConferenceState(ConferenceStatus.ERROR);
                this.getEventBus().post((Object)new ConferenceStatusUpdatedEvent(conference, conference.getState()));
                solver.reject(error);
            });
        });
    }
}

