/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.information;

import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.sdk.media.audio.ParticipantPosition;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v1.RestParticipant;
import com.voxeet.sdk.services.conference.information.ConferenceParticipantType;
import com.voxeet.sdk.services.conference.information.ConferenceStatus;
import com.voxeet.sdk.services.conference.information.LocalConferenceType;
import com.voxeet.sdk.services.media.VideoState;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Annotate
public class ConferenceInformation {
    private static final String TAG = ConferenceInformation.class.getSimpleName();
    @NonNull
    private Conference mConference;
    @NonNull
    private Map<String, String> participantIdsCached;
    private LocalConferenceType mConferenceType;
    @NonNull
    private List<Participant> mLastInvitationReceived;
    private ConferenceStatus state = ConferenceStatus.DEFAULT;
    private HashMap<String, ParticipantPosition> mPositions;
    private boolean mOwnScreenShareStarted = false;
    private ConferenceParticipantType participantType;
    private boolean telecomMode = false;
    @NonNull
    private VideoState videoState = VideoState.STOPPED;
    private boolean mOwnVideoStarted = false;

    private ConferenceInformation() {
        this.participantType = ConferenceParticipantType.NORMAL;
        this.participantIdsCached = new HashMap<String, String>();
        this.mLastInvitationReceived = new ArrayList<Participant>();
        this.mConference = new Conference(this);
        this.mConferenceType = LocalConferenceType.NONE;
        this.mPositions = new HashMap();
    }

    @NoDocumentation
    public ConferenceInformation(@NonNull Participant localParticipant, @NonNull String conferenceId) {
        this();
        this.mConference.updateParticipant(localParticipant);
        this.mConference.setConferenceId(conferenceId);
    }

    @NonNull
    public ParticipantPosition getPosition(@NonNull Participant participant) {
        return this.getPosition(participant.getId());
    }

    @NonNull
    public ParticipantPosition getPosition(@NonNull String participantId) {
        ParticipantPosition p = this.mPositions.get(participantId);
        if (null == p) {
            p = new ParticipantPosition(0.0, 0.0);
        }
        return p;
    }

    public void setPosition(@NonNull Participant participant, @NonNull ParticipantPosition point) {
        this.setPosition(participant.getId(), point);
    }

    public void setPosition(@NonNull String participantId, @NonNull ParticipantPosition point) {
        this.mPositions.put(participantId, point);
    }

    @NonNull
    public Conference getConference() {
        return this.mConference;
    }

    @NoDocumentation
    public void setConference(@NonNull Conference conference) {
        this.mConference = conference;
    }

    @NoDocumentation
    public void setConferenceType(@NonNull LocalConferenceType type) {
        this.mConferenceType = type;
    }

    @NonNull
    public LocalConferenceType getConferenceType() {
        return this.mConferenceType;
    }

    @Deprecated
    @NoDocumentation
    @NonNull
    public Map<String, String> getParticipantIdsCached() {
        return this.participantIdsCached;
    }

    @Deprecated
    @NoDocumentation
    @NonNull
    public List<Participant> getLastInvitationReceived() {
        return this.mLastInvitationReceived;
    }

    @NoDocumentation
    public void setConferenceState(@NonNull ConferenceStatus state) {
        this.state = state;
    }

    @NonNull
    public ConferenceStatus getConferenceState() {
        return this.state;
    }

    @NoDocumentation
    public void setRequestedOwnVideo(boolean ownVideoStarted) {
        Log.d((String)TAG, (String)("setRequestedOwnVideo: " + ownVideoStarted));
        this.mOwnVideoStarted = ownVideoStarted;
    }

    public boolean isOwnVideoStarted() {
        Log.d((String)TAG, (String)("isOwnVideoStarted: " + this.mOwnVideoStarted));
        return this.mOwnVideoStarted;
    }

    @NoDocumentation
    public void setConferenceParticipantType(@NonNull ConferenceParticipantType participantType) {
        this.participantType = participantType;
    }

    public ConferenceParticipantType getConferenceParticipantType() {
        return this.participantType;
    }

    public boolean isBroadcaster() {
        return ConferenceParticipantType.BROADCASTER.equals((Object)this.participantType);
    }

    public boolean isListener() {
        return ConferenceParticipantType.LISTENER.equals((Object)this.participantType);
    }

    @NoDocumentation
    public void setScreenShareOn(boolean enable) {
        this.mOwnScreenShareStarted = enable;
    }

    public boolean isScreenShareOn() {
        return this.mOwnScreenShareStarted;
    }

    @NoDocumentation
    public void participantsToConferenceParticipants(List<RestParticipant> participants) {
        if (null != participants) {
            Map<String, String> cache = this.getParticipantIdsCached();
            for (RestParticipant participant : participants) {
                cache.put(participant.getExternalId(), participant.getExternalId());
            }
            Conference conference = this.getConference();
            conference.updateRestParticipants(participants);
        }
    }

    @NoDocumentation
    public void setTelecomMode(boolean telecomMode) {
        this.telecomMode = telecomMode;
    }

    @NoDocumentation
    public boolean isTelecomMode() {
        return this.telecomMode;
    }

    @NonNull
    public VideoState getVideoState() {
        return this.videoState;
    }

    @NoDocumentation
    void clean() {
        this.mPositions.clear();
        this.mConference.getParticipants().clear();
    }

    @NoDocumentation
    public List<Participant> getParticipants() {
        return this.getConference().getParticipants();
    }

    public String toString() {
        return "ConferenceInformation{Conference='" + this.mConference + '\'' + '}';
    }

    void setVideoState(@NonNull VideoState videoState) {
        this.videoState = videoState;
    }
}

