/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.content.Context;
import android.os.Build;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.VoxeetSDK;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.crypto.AbstractNativeMediaCryptoCallback;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.audio2.devices.description.DeviceType;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.events.error.CameraSwitchErrorEvent;
import com.voxeet.sdk.events.sdk.CameraSwitchSuccessEvent;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.media.camera.CameraContext;
import com.voxeet.sdk.media.camera.CameraEnumeratorLollipopWrapper;
import com.voxeet.sdk.media.camera.CameraEnumeratorPreLollipopWrapper;
import com.voxeet.sdk.services.AbstractVoxeetService;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.media.VideoSinkHolder;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Opt;
import com.voxeet.sdk.utils.Validate;
import com.voxeet.sdk.views.ViewFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.VideoSink;

@Annotate
public class MediaDeviceService
extends AbstractVoxeetService {
    private CameraContext enumerator;
    private AbstractNativeMediaCryptoCallback mediaCryptoCallback;
    private MediaSDK media;
    private boolean isAudio3DEnabled;
    private CopyOnWriteArrayList<VideoSinkHolder> videoSinkHolders = new CopyOnWriteArrayList();

    @NoDocumentation
    public MediaDeviceService(@NonNull SdkEnvironmentHolder instance) {
        super(instance);
        this.enumerator = Build.VERSION.SDK_INT >= 21 ? new CameraEnumeratorLollipopWrapper(instance.voxeetSdk.getApplicationContext()) : new CameraEnumeratorPreLollipopWrapper(instance.voxeetSdk.getApplicationContext());
        this.enumerator.setDefaultCameraFront(true);
        this.isAudio3DEnabled = false;
        ViewFactory.set((ViewFactory.MediaProvider)new ViewFactory.MediaProvider(){

            public EglBase.Context getEglContext() {
                return MediaDeviceService.this.getEglContext();
            }

            public boolean hasMedia() {
                return MediaDeviceService.this.hasMedia();
            }

            public boolean attachMediaStream(MediaStream stream, VideoSink videoSink) {
                return MediaDeviceService.this.attachMediaStream(stream, videoSink);
            }

            public void unAttachMediaStream(VideoSink videoSink) {
                MediaDeviceService.this.unAttachMediaStream(videoSink);
            }
        });
    }

    @NoDocumentation
    public boolean hasMedia() {
        return null != this.media;
    }

    @NoDocumentation
    @Nullable
    public MediaSDK getMedia() {
        return this.media;
    }

    @Nullable
    public EglBase.Context getEglContext() {
        return (EglBase.Context)Opt.of((Object)((Object)this.media)).then(MediaEngine::getEglBase).then(EglBase::getEglBaseContext).orNull();
    }

    public void setCryptoCallback(@Nullable AbstractNativeMediaCryptoCallback callback) {
        this.mediaCryptoCallback = callback;
    }

    @MainThread
    public boolean attachMediaStream(@NonNull MediaStream stream, @NonNull VideoSink videoSink) {
        MediaSDK media = this.media;
        if (null == media) {
            return false;
        }
        VideoSinkHolder holder = this.getOrCreate(videoSink);
        if (null == holder) {
            return false;
        }
        this.unAttachMediaStream(videoSink);
        holder.attach(media, stream);
        return true;
    }

    @MainThread
    public boolean unAttachMediaStream(@NonNull VideoSink videoSink) {
        VideoSinkHolder holder = this.getOrCreate(videoSink);
        if (null == holder) {
            return false;
        }
        holder.unattach(this.media);
        return true;
    }

    public boolean isAudio3DEnabled() {
        return this.isAudio3DEnabled;
    }

    public boolean setAudio3DEnabled(boolean enable) {
        this.isAudio3DEnabled = enable;
        if (null != this.media) {
            return this.media.setAudio3D(enable);
        }
        return false;
    }

    @NonNull
    public Promise<Boolean> switchCamera() {
        return new Promise((resolve, reject) -> {
            Validate.notNull((Object)this.getMedia(), "media");
            this.getMedia().switchCamera(new CameraVideoCapturer.CameraSwitchHandler(){

                public void onCameraSwitchDone(boolean isFrontCamera) {
                    MediaDeviceService.this.getCameraContext().setDefaultCameraFront(isFrontCamera);
                    MediaDeviceService.this.getEventBus().post((Object)new CameraSwitchSuccessEvent(isFrontCamera));
                    resolve.call((Object)true);
                }

                public void onCameraSwitchError(String errorDescription) {
                    MediaDeviceService.this.getEventBus().post((Object)new CameraSwitchErrorEvent(errorDescription));
                    resolve.call((Object)false);
                }
            });
        });
    }

    @NonNull
    public CameraContext getCameraContext() {
        return this.enumerator;
    }

    @MainThread
    @Nullable
    private VideoSinkHolder getOrCreate(@Nullable VideoSink videoSink) {
        if (null == videoSink) {
            return null;
        }
        for (VideoSinkHolder holder : this.videoSinkHolders) {
            if (!holder.equals(videoSink)) continue;
            return holder;
        }
        VideoSinkHolder holder = new VideoSinkHolder(videoSink);
        this.videoSinkHolders.add(holder);
        return holder;
    }

    @NoDocumentation
    void releaseMedia() {
        for (VideoSinkHolder holder : this.videoSinkHolders) {
            if (!holder.hasVideoSink()) continue;
            holder.clear();
        }
        this.videoSinkHolders.clear();
        if (null != this.media) {
            VoxeetSDK.audio().enumerateDevices().then(devices -> {
                MediaDevice mediaDevice = null;
                for (MediaDevice device : (List)Opt.of((Object)devices).or(new ArrayList())) {
                    if (!DeviceType.NORMAL_MEDIA.equals((Object)device.deviceType())) continue;
                    mediaDevice = device;
                }
                if (null != mediaDevice) {
                    return VoxeetSDK.audio().connect(mediaDevice);
                }
                return Promise.resolve((Object)true);
            }).then(result -> {}).error(Throwable::printStackTrace);
            this.media.stop();
        }
        this.media = null;
    }

    @NoDocumentation
    void createMedia(Context context, String participantId, MediaEngine.StreamListener mediaStreamListener, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler, boolean videoOn, boolean useMic) throws MediaEngineException {
        this.media = new MediaSDK(context, participantId, mediaStreamListener, cameraEventsHandler, videoOn, useMic, this.mediaCryptoCallback);
        this.media.setAudio3D(this.isAudio3DEnabled);
    }
}

