/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models.v1;

import android.support.annotation.NonNull;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.models.v1.ConferenceQuality;
import com.voxeet.sdk.models.v1.UserProfile;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConferenceUser {
    private String TAG = ConferenceUser.class.getSimpleName();
    @JsonIgnore
    private boolean isMuted = false;
    @JsonIgnore
    private ParticipantInfo participantInfo;
    @JsonProperty(value="user_id")
    private String userId;
    private String quality;
    @JsonIgnore
    private String deviceType;
    @JsonIgnore
    private String status;
    @JsonIgnore
    private ConferenceParticipantStatus conferenceStatus;
    private String conferenceStatusToString;
    private boolean isOwner;
    @JsonIgnore
    private UserProfile profile;
    private boolean isRecordingOwner = false;
    private boolean isWhispering = false;

    public ConferenceUser() {
        this.participantInfo = null;
    }

    public ConferenceUser(String userId, String device) {
        this.userId = userId;
        this.deviceType = device;
        this.conferenceStatus = ConferenceParticipantStatus.ON_AIR;
        this.participantInfo = null;
        this.isMuted = false;
        this.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
    }

    public ConferenceUser(String userId, String device, ParticipantInfo participantInfo) {
        this.userId = userId;
        this.deviceType = device;
        this.profile = new UserProfile();
        this.profile.setUserId(userId);
        this.profile.setPhotoId(participantInfo.getAvatarUrl());
        this.profile.setFirstName(participantInfo.getName());
        this.profile.setLastName(participantInfo.getName());
        this.profile.setNickName(participantInfo.getName());
        this.setWhispering(false);
        this.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
        this.participantInfo = participantInfo;
        this.isMuted = false;
    }

    public ConferenceUser(UserProfile profile) {
        this.profile = profile;
        this.userId = profile.getUserId();
        this.setConferenceStatus(ConferenceParticipantStatus.IN_PROGRESS);
        this.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
    }

    public boolean isRecordingOwner() {
        return this.isRecordingOwner;
    }

    public boolean isWhispering() {
        return this.isWhispering;
    }

    public void setOwner(boolean owner) {
        this.isOwner = owner;
    }

    public void setRecordingOwner(boolean recordingOwner) {
        this.isRecordingOwner = recordingOwner;
    }

    public void setWhispering(boolean whispering) {
        this.isWhispering = whispering;
    }

    public void setIsRecordingOwner(boolean isRecordingOwner) {
        this.isRecordingOwner = isRecordingOwner;
    }

    public ConferenceParticipantStatus getConferenceStatus() {
        if (this.conferenceStatus == null && this.conferenceStatusToString != null) {
            return ConferenceParticipantStatus.valueOf((String)this.conferenceStatusToString);
        }
        return this.conferenceStatus;
    }

    public ConferenceUser setConferenceStatus(@NonNull ConferenceParticipantStatus conferenceStatus) {
        this.conferenceStatus = conferenceStatus;
        this.conferenceStatusToString = conferenceStatus.toString();
        return this;
    }

    public UserProfile getProfile() {
        return this.profile;
    }

    public void setProfile(UserProfile profile) {
        this.profile = profile;
    }

    @Deprecated
    public String getStatus() {
        return this.getConferenceStatusToString();
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setParticipantInfo(ParticipantInfo participantInfo) {
        this.participantInfo = participantInfo;
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public ParticipantInfo getParticipantInfo() {
        return this.participantInfo;
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    public void setMuted(boolean muted) {
        this.isMuted = muted;
    }

    public String getConferenceStatusToString() {
        return this.conferenceStatusToString;
    }

    public void setConferenceStatusToString(String conferenceStatusToString) {
        this.conferenceStatusToString = conferenceStatusToString;
    }

    public boolean isOwner() {
        return this.isOwner;
    }

    public ConferenceUser setIsOwner(boolean isOwner) {
        this.isOwner = isOwner;
        return this;
    }

    public String toString() {
        return "ConferenceUser{participantInfo=" + this.participantInfo + ", participantId='" + this.userId + '\'' + '}';
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof ConferenceUser) {
            ConferenceUser user = (ConferenceUser)obj;
            return null != user.getUserId() && user.getUserId().equals(this.getUserId());
        }
        return super.equals(obj);
    }

    public void updateIfNeeded(String name, String avatarUrl) {
        if (null == this.participantInfo) {
            this.participantInfo = new ParticipantInfo();
        }
        this.participantInfo.setName(name);
        this.participantInfo.setAvatarUrl(avatarUrl);
    }
}

