/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.webrtc.Logging;
import org.webrtc.MediaCodecUtils;
import org.webrtc.VideoCodecType;

public final class MediaCodecVideoHelperFactory {
    public static final String TAG = MediaCodecVideoHelperFactory.class.getSimpleName();

    private MediaCodecVideoHelperFactory() {
    }

    @NonNull
    public static ArrayList<MediaCodecInfo> getCodecs() {
        ArrayList<MediaCodecInfo> list = new ArrayList<MediaCodecInfo>();
        if (Build.VERSION.SDK_INT >= 16) {
            for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
                Object info = null;
                try {
                    list.add(MediaCodecList.getCodecInfoAt((int)i));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    Logging.e((String)TAG, (String)"Cannot retrieve decoder codec info", (Throwable)e);
                }
            }
        }
        return list;
    }

    @Nullable
    private static MediaCodecInfo findCodecForType(VideoCodecType type, @NonNull ValidateMediaCodecInfo validate) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e((String)TAG, (String)"Cannot retrieve decoder codec info", (Throwable)e);
            }
            if (info == null || validate.isValid(info) || !validate.isSupportedCodec(info, type)) continue;
            return info;
        }
        return null;
    }

    private abstract class ValidateMediaCodecInfo {
        private int[] color_formats;

        private ValidateMediaCodecInfo() {
        }

        public ValidateMediaCodecInfo(int[] color_formats) {
            this.color_formats = color_formats;
        }

        private boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type) {
            if (!MediaCodecUtils.codecSupportsType((MediaCodecInfo)info, (VideoCodecType)type)) {
                return false;
            }
            if (MediaCodecUtils.selectColorFormat((int[])this.color_formats, (MediaCodecInfo.CodecCapabilities)info.getCapabilitiesForType(type.mimeType())) == null) {
                return false;
            }
            return this.isValid(info, type);
        }

        abstract boolean isValid(@NonNull MediaCodecInfo var1);

        abstract boolean isValid(@NonNull MediaCodecInfo var1, @NonNull VideoCodecType var2);
    }
}

