/*
 * Decompiled with CFR 0.152.
 */
package eu.codlab.simplepromise;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import eu.codlab.simplepromise.AbstractPromise;
import eu.codlab.simplepromise.PromiseAll;
import eu.codlab.simplepromise.PromiseDebug;
import eu.codlab.simplepromise.PromiseInOut;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.List;

public class Promise<TYPE>
extends AbstractPromise<TYPE> {
    @NonNull
    private static Handler sHandler = new Handler(Looper.getMainLooper());
    private PromiseSolver<TYPE> mSolver;
    private PromiseInOut<Object, TYPE> mPromiseInOut;

    public static <T> Promise<List<T>> all(AbstractPromise<T> ... promises) {
        return new PromiseAll<T>(promises).all();
    }

    public static void setHandler(@NonNull Handler handler) {
        sHandler = handler;
    }

    @NonNull
    public static Handler getHandler() {
        return sHandler;
    }

    private Promise() {
    }

    public Promise(PromiseSolver<TYPE> solver) {
        this();
        PromiseDebug.activate(true);
        this.mSolver = solver;
        this.mPromiseInOut = new PromiseInOut(this);
    }

    @Override
    public <TYPE_RESULT> PromiseInOut<TYPE, TYPE_RESULT> then(PromiseExec<TYPE, TYPE_RESULT> to_resolve) {
        PromiseDebug.log("Promise", "then PromiseExec");
        return this.then(new PromiseInOut<TYPE, TYPE_RESULT>(to_resolve));
    }

    public <TYPE_RESULT> PromiseInOut<TYPE, TYPE_RESULT> then(final TYPE_RESULT resolved) {
        return this.then((TYPE_RESULT)new PromiseExec<TYPE, TYPE_RESULT>(){

            @Override
            public void onCall(@Nullable TYPE result, @NonNull Solver<TYPE_RESULT> solver) {
                solver.resolve(resolved);
            }
        });
    }

    public <TYPE_RESULT> void error(ErrorPromise to_error) {
        PromiseDebug.log("Promise", "then error");
        PromiseInOut promise_inout = new PromiseInOut(to_error);
        promise_inout.setParent(this.mPromiseInOut);
        this.mPromiseInOut.setChild(promise_inout);
        promise_inout.execute();
    }

    public void execute() {
        PromiseDebug.log("Promise", "execute " + this.mPromiseInOut);
        this.mPromiseInOut.execute();
    }

    void resolve() {
        PromiseDebug.log("Promise", "resolve " + this.mPromiseInOut);
        this.mPromiseInOut.execute(this);
    }

    PromiseSolver<TYPE> getSolver() {
        return this.mSolver;
    }

    @Override
    public <TYPE_RESULT> PromiseInOut<TYPE, TYPE_RESULT> then(Promise<TYPE_RESULT> to_resolve) {
        return this.then(super.then(to_resolve));
    }

    @Override
    private <TYPE_RESULT> PromiseInOut<TYPE, TYPE_RESULT> then(PromiseInOut<TYPE, TYPE_RESULT> created_inout) {
        PromiseDebug.log("Promise", "then PromiseInOut " + created_inout);
        created_inout.setParent(this.mPromiseInOut);
        this.mPromiseInOut.setChild(created_inout);
        return created_inout;
    }
}

