/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.voxeet.sdk.models.v1.MeetingAttributes;
import com.voxeet.sdk.models.v1.UserProfile;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MeetingEvent
implements Comparable<MeetingEvent> {
    private static final String TAG = MeetingEvent.class.getSimpleName();
    @JsonProperty(value="evtUser")
    private UserProfile owner;
    private String meetingId;
    private String meetingEventId;
    private String meetingEventType;
    @JsonProperty(value="timestamp")
    private long time;
    private boolean notification;
    private MeetingAttributes attributes;
    @JsonIgnore
    private boolean hasGroupDate;

    public MeetingAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(MeetingAttributes attributes) {
        this.attributes = attributes;
    }

    public UserProfile getOwner() {
        return this.owner;
    }

    public boolean hasGroupDate() {
        return this.hasGroupDate;
    }

    public void setHasGroupDate(boolean hasGroupDate) {
        this.hasGroupDate = hasGroupDate;
    }

    public void setOwner(UserProfile owner) {
        this.owner = owner;
    }

    public String getMeetingId() {
        return this.meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public String getMeetingEventId() {
        return this.meetingEventId;
    }

    public void setMeetingEventId(String meetingEventId) {
        this.meetingEventId = meetingEventId;
    }

    public Type getMeetingEventType() {
        return Type.valueOf(this.meetingEventType);
    }

    public void setMeetingEventType(String meetingEventType) {
        this.meetingEventType = meetingEventType;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isNotification() {
        return this.notification;
    }

    public void setNotification(boolean notification) {
        this.notification = notification;
    }

    @Override
    public int compareTo(MeetingEvent another) {
        return new Date(another.getTime()).compareTo(new Date(this.getTime()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeetingEvent event = (MeetingEvent)o;
        return this.meetingEventId != null ? this.meetingEventId.equalsIgnoreCase(event.meetingEventId) : event.meetingEventId == null;
    }

    public int hashCode() {
        return this.meetingEventId != null ? this.meetingEventId.hashCode() : 0;
    }

    public String toString() {
        return this.meetingEventId;
    }

    static enum Type {
        CONFERENCE_STARTED("CONFERENCE_STARTED"),
        USER_CONFERENCE_JOIN("USER_CONFERENCE_JOIN"),
        USER_CONFERENCE_LEFT("USER_CONFERENCE_LEFT"),
        CONFERENCE_ATTENDED("CONFERENCE_ATTENDED"),
        CONFERENCE_MISSED("CONFERENCE_MISSED"),
        CONFERENCE_CANCELED("CONFERENCE_CANCELED"),
        SCHEDULED_MEET_CREATED("SCHEDULED_MEET_CREATED"),
        SCHEDULED_MEET_UPDATED("SCHEDULED_MEET_UPDATED"),
        SCHEDULED_MEET_CANCELED("SCHEDULED_MEET_CANCELED"),
        MESSAGE_SENT("MESSAGE_SENT"),
        MESSAGE_RECEIVED("MESSAGE_RECEIVED"),
        FILE_SENT("FILE_SENT"),
        FILE_RECEIVED("FILE_RECEIVED"),
        USER_MEETING_JOIN("USER_MEETING_JOIN"),
        USER_MEETING_LEFT("USER_MEETING_LEFT"),
        MEETING_CREATED("MEETING_CREATED"),
        NEW_CONTACT("NEW_CONTACT");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

