/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.authenticate;

import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public class VoxeetCookieJar
implements CookieJar {
    @NonNull
    private final HashMap<String, List<Cookie>> cookieStore = new HashMap();
    @NonNull
    private final String url;

    public VoxeetCookieJar(@NonNull String url) {
        this.url = url;
    }

    public List<Cookie> getCookies(String url) {
        for (Map.Entry<String, List<Cookie>> o : this.cookieStore.entrySet()) {
            Map.Entry<String, List<Cookie>> pair = o;
            if (!pair.getKey().contains(url)) continue;
            return this.cookieStore.get(pair.getKey());
        }
        return null;
    }

    public String createCookie(String value) {
        HttpUrl parsed = HttpUrl.parse((String)this.url);
        if (null == parsed) {
            return null;
        }
        Cookie cookie = Cookie.parse((HttpUrl)parsed, (String)value);
        if (cookie != null && cookie.toString().length() > 0) {
            this.cookieStore.put(this.url, Collections.singletonList(cookie));
            return cookie.value();
        }
        return null;
    }

    public String retrieveCookie() {
        String cookie = VoxeetPreferences.getLoginCookie();
        if (cookie != null && cookie.length() > 0) {
            cookie = this.createCookie(cookie);
        } else {
            List<Cookie> cookies = this.getCookies(this.url);
            if (cookies != null && cookies.size() > 0) {
                cookie = cookies.get(0).value();
                VoxeetPreferences.saveLoginCookie(cookies.get(0).toString());
            }
        }
        return cookie;
    }

    public void saveFromResponse(@NonNull HttpUrl url, @NonNull List<Cookie> cookies) {
        String base = url.scheme() + "://" + url.host() + ":" + url.port();
        Log.d((String)"VoxeetCookieJar", (String)("saveFromResponse: " + base + " " + Arrays.toString(cookies.toArray())));
        ArrayList<Cookie> new_cookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            if (null == cookie || "deleted".equalsIgnoreCase(cookie.value()) || !new Date().before(new Date(cookie.expiresAt()))) continue;
            new_cookies.add(cookie);
        }
        this.cookieStore.put(base, new_cookies);
    }

    public List<Cookie> loadForRequest(@NonNull HttpUrl url) {
        String base = url.scheme() + "://" + url.host() + ":" + url.port();
        ArrayList cookies = this.cookieStore.get(base);
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                Log.d((String)"VoxeetCookieJar", (String)("loadForRequest: " + cookie.value() + " " + cookie.toString()));
            }
        }
        return cookies != null ? cookies : new ArrayList();
    }
}

