/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.MediaStreamType;
import com.voxeet.android.media.SdpCandidate;
import com.voxeet.audio.AudioRoute;
import com.voxeet.authent.models.DeviceType;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.network.endpoints.ISdkConferenceRService;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.AudioService;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.SessionService;
import com.voxeet.sdk.core.services.TimeoutRunnable;
import com.voxeet.sdk.core.services.builders.ConferenceCreateInformation;
import com.voxeet.sdk.core.services.builders.ConferenceJoinInformation;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformationHolder;
import com.voxeet.sdk.core.services.conference.information.ConferenceState;
import com.voxeet.sdk.core.services.conference.information.ConferenceUserType;
import com.voxeet.sdk.core.services.conference.information.LocalConferenceType;
import com.voxeet.sdk.core.services.conference.promises.CreateConferencePromiseable;
import com.voxeet.sdk.core.services.conference.promises.DeclinePromise;
import com.voxeet.sdk.core.services.conference.promises.GetConferenceHistoryPromiseable;
import com.voxeet.sdk.core.services.conference.promises.GetConferenceStatus;
import com.voxeet.sdk.core.services.conference.promises.GetConferenceStatusPromiseable;
import com.voxeet.sdk.core.services.conference.promises.InvitePromise;
import com.voxeet.sdk.core.services.conference.promises.JoinPromise;
import com.voxeet.sdk.core.services.conference.promises.LeavePromise;
import com.voxeet.sdk.core.services.conference.promises.ReplayPromise;
import com.voxeet.sdk.core.services.conference.promises.SendBroadcastMessagePromise;
import com.voxeet.sdk.core.services.conference.promises.StartRecordingPromiseable;
import com.voxeet.sdk.core.services.conference.promises.StartScreensharePromise;
import com.voxeet.sdk.core.services.conference.promises.StartVideoPromise;
import com.voxeet.sdk.core.services.conference.promises.StopRecordingPromiseable;
import com.voxeet.sdk.core.services.conference.promises.StopScreenSharePromise;
import com.voxeet.sdk.core.services.conference.promises.StopVideoPromise;
import com.voxeet.sdk.core.services.conference.promises.SubscribeConferenceEventPromiseable;
import com.voxeet.sdk.core.services.conference.promises.SubscribeForCallStartPromiseable;
import com.voxeet.sdk.core.services.conference.promises.UnsubscribeConferenceEventPromiseable;
import com.voxeet.sdk.core.services.conference.promises.UnsubscribeForCallStartPromiseable;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.events.error.ConferenceCreatedError;
import com.voxeet.sdk.events.error.ConferenceJoinedError;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.ParticipantAddedErrorEvent;
import com.voxeet.sdk.events.error.PermissionRefusedEvent;
import com.voxeet.sdk.events.promises.InConferenceException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.promises.PromiseConferenceJoinedErrorException;
import com.voxeet.sdk.events.promises.PromiseParticipantAddedErrorEventException;
import com.voxeet.sdk.events.restapi.ConferenceStatusResult;
import com.voxeet.sdk.events.restapi.ResumeConference;
import com.voxeet.sdk.events.sdk.ConferenceJoinedSuccessEvent;
import com.voxeet.sdk.events.sdk.ConferencePreJoinedEvent;
import com.voxeet.sdk.events.sdk.ConferenceUserCallDeclinedEvent;
import com.voxeet.sdk.events.sdk.ConferenceUserQualityUpdatedEvent;
import com.voxeet.sdk.events.sdk.ConferenceUsersInvitedResult;
import com.voxeet.sdk.events.sdk.DeclineConferenceResultEvent;
import com.voxeet.sdk.events.sdk.GetConferenceHistoryResult;
import com.voxeet.sdk.events.sdk.IncomingCallEvent;
import com.voxeet.sdk.events.sdk.SocketConnectEvent;
import com.voxeet.sdk.events.v2.StreamAddedEvent;
import com.voxeet.sdk.events.v2.StreamRemovedEvent;
import com.voxeet.sdk.events.v2.StreamUpdatedEvent;
import com.voxeet.sdk.events.v2.UserAddedEvent;
import com.voxeet.sdk.events.v2.UserUpdatedEvent;
import com.voxeet.sdk.events.websocket.RenegociationEndedEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.factories.VoxeetIntentFactory;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.json.ConferenceEnded;
import com.voxeet.sdk.json.InvitationReceivedEvent;
import com.voxeet.sdk.json.JoinParameters;
import com.voxeet.sdk.json.OfferCreated;
import com.voxeet.sdk.json.OwnConferenceCreated;
import com.voxeet.sdk.json.OwnConferenceUserSwitch;
import com.voxeet.sdk.json.ParticipantAdded;
import com.voxeet.sdk.json.ParticipantUpdated;
import com.voxeet.sdk.json.QualityUpdated;
import com.voxeet.sdk.json.RecordingStatusUpdateEvent;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.json.internal.MetadataHolder;
import com.voxeet.sdk.json.internal.ParamsHolder;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.media.audio.UserPosition;
import com.voxeet.sdk.media.camera.CameraContext;
import com.voxeet.sdk.media.peer.PendingPeerCallback;
import com.voxeet.sdk.media.peer.SdpDescription;
import com.voxeet.sdk.media.peer.SdpMessage;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v1.CandidatesPush;
import com.voxeet.sdk.models.v1.ConferenceType;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.models.v1.CreateConferenceResult;
import com.voxeet.sdk.models.v1.Invitation;
import com.voxeet.sdk.models.v1.OfferCandidate;
import com.voxeet.sdk.models.v1.OfferDescription;
import com.voxeet.sdk.models.v1.Participant;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.models.v1.SdkParticipant;
import com.voxeet.sdk.utils.AndroidManifest;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.ConferenceUtils;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Validate;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.CameraVideoCapturer;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Annotate
public class ConferenceService
extends AbstractVoxeetService<ISdkConferenceRService> {
    private static final String TAG = ConferenceService.class.getSimpleName();
    private final VoxeetSdk mInstance;
    private VoxeetSdk mSDK;
    private ConferenceSdkObservableProvider mConferenceObservableProvider;
    private EventBus mEventBus;
    private boolean isRecording = false;
    private boolean mInConference = false;
    private long mTimeOutTimer = -1L;
    private ReentrantLock joinLock = new ReentrantLock();
    private boolean isDefaultOnSpeaker;
    private String mConferenceId = null;
    private ConferenceInformationHolder mConferenceInformationHolder = new ConferenceInformationHolder();
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private Context mContext;
    @Nullable
    private TimeoutRunnable timeoutRunnable = null;
    private String automaticTelecomModePrefix = null;
    private boolean telecomMode = false;
    private MediaEngine.StreamListener mediaStreamListener = new MediaEngine.StreamListener(){

        public void onStreamAdded(final @NonNull String peer, final @NonNull MediaStream stream) {
            Log.d((String)TAG, (String)("onStreamAdded: stream for peer " + peer));
            ConferenceService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    ConferenceInformation conferenceInformation = ConferenceService.this.getCurrentConferenceInformation();
                    Log.d((String)TAG, (String)("New stream for user " + peer + " checking... (ours is " + VoxeetPreferences.id()));
                    User user = ConferenceService.this.findUserById(peer);
                    if (null != conferenceInformation && null == user) {
                        Log.d((String)TAG, (String)("run: WARNING obtained stream for user which did not existed " + peer));
                        user = new User(peer, null);
                        conferenceInformation.getConference().updateUser(user);
                    }
                    if (user != null) {
                        if (!peer.equalsIgnoreCase(VoxeetSdk.session().getUserId()) && ConferenceService.this.mTimeOutTimer != -1L) {
                            ConferenceService.this.removeTimeoutCallbacks();
                        }
                        user.streamsHandler().insertOrUpdate(stream);
                        ConferenceService.this.updateConferenceFromUsers();
                        ConferenceService.this.mEventBus.post((Object)new StreamAddedEvent(conferenceInformation.getConference(), user, stream));
                    } else {
                        Log.d((String)TAG, (String)"run: unknown user in stream added");
                    }
                }
            });
        }

        public void onStreamUpdated(final @NonNull String peer, final @NonNull MediaStream stream) {
            Log.d((String)TAG, (String)("onStreamUpdated: screen for peer " + peer));
            ConferenceService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    ConferenceInformation conferenceInformation = ConferenceService.this.getCurrentConferenceInformation();
                    User user = ConferenceService.this.findUserById(peer);
                    if (null != conferenceInformation && null == user) {
                        Log.d((String)TAG, (String)("run: WARNING obtained stream for user which did not existed " + peer));
                        user = new User(peer, null);
                        conferenceInformation.getConference().updateUser(user);
                    }
                    Log.d((String)TAG, (String)("Updated stream for user " + user));
                    if (user != null) {
                        user.streamsHandler().insertOrUpdate(stream);
                        ConferenceService.this.updateConferenceFromUsers();
                        ConferenceService.this.mEventBus.post((Object)new StreamUpdatedEvent(conferenceInformation.getConference(), user, stream));
                    } else {
                        Log.d((String)TAG, (String)"run: unknown user in stream updated");
                    }
                }
            });
        }

        public void onStreamRemoved(final @NonNull String peer) {
            Log.d((String)TAG, (String)"onStreamRemoved: OnStreamRemoved");
            ConferenceService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    ConferenceService.this.removeStreamForUser(peer, MediaStreamType.Camera);
                }
            });
        }

        public void onScreenStreamAdded(@NonNull String peer, @NonNull MediaStream stream) {
            Log.d((String)TAG, (String)("onScreenStreamAdded: screen for peer " + peer + " calling onStreamAdded"));
            this.onStreamAdded(peer, stream);
        }

        public void onScreenStreamRemoved(final @NonNull String peer) {
            ConferenceService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    ConferenceService.this.removeStreamForUser(peer, MediaStreamType.Camera);
                }
            });
        }

        public void onShutdown() {
        }

        public void onIceCandidateDiscovered(String peer, SdpCandidate[] candidates) {
            if (null == ConferenceService.this.getConferenceId()) {
                return;
            }
            Call<ResponseBody> call = ConferenceService.this.mConferenceObservableProvider.candidates(ConferenceService.this.getConferenceId(), peer, new CandidatesPush(candidates));
            call.enqueue((Callback)new Callback<ResponseBody>(){

                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    Log.d((String)TAG, (String)"onResponse: Candidates sent ");
                }

                public void onFailure(Call<ResponseBody> call, Throwable t) {
                    t.printStackTrace();
                }
            });
        }
    };
    private CameraVideoCapturer.CameraEventsHandler cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

        public void onCameraError(String s) {
            Log.d((String)TAG, (String)"onCameraError: error...");
            ConferenceService.this.stopVideo().then(new PromiseExec<Boolean, Object>(){

                @Override
                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onCall: stopped video after camera issue " + result));
                }
            }).error(new ErrorPromise(){

                @Override
                public void onError(@NonNull Throwable error) {
                    error.printStackTrace();
                }
            });
        }

        public void onCameraDisconnected() {
            Log.d((String)TAG, (String)"onCameraDisconnected");
        }

        public void onCameraFreezed(String s) {
            Log.d((String)TAG, (String)("onCameraFreezed: " + s));
        }

        public void onCameraOpening(String s) {
            Log.d((String)TAG, (String)("onCameraOpening: " + s));
        }

        public void onFirstFrameAvailable() {
            Log.d((String)TAG, (String)"onFirstFrameAvailable");
        }

        public void onCameraClosed() {
            Log.d((String)TAG, (String)"onCameraClosed");
        }
    };
    private boolean isDefaultVideo = false;
    private boolean isDefaultMute = false;
    private boolean isICERestartEnabled = false;

    private void removeStreamForUser(@NonNull String peer, MediaStreamType mediaStreamType) {
        ConferenceInformation conferenceInformation = this.getCurrentConferenceInformation();
        User user = this.findUserById(peer);
        if (null != conferenceInformation && null == user) {
            Log.d((String)TAG, (String)("run: WARNING obtained stream for user which did not existed " + peer));
            user = new User(peer, null);
            conferenceInformation.getConference().updateUser(user);
        }
        Log.d((String)TAG, (String)("Remove stream " + (Object)((Object)mediaStreamType) + " for user " + user));
        if (user != null) {
            MediaStream stream = user.streamsHandler().getFirst(mediaStreamType);
            user.streamsHandler().remove(mediaStreamType);
            this.updateConferenceFromUsers();
            this.mEventBus.post((Object)new StreamRemovedEvent(conferenceInformation.getConference(), user, stream));
        } else {
            Log.d((String)TAG, (String)("run: unknown user in stream updated" + Arrays.toString(this.getConferenceUsers().toArray())));
        }
    }

    @NoDocumentation
    public ConferenceService(VoxeetSdk instance, long timeout) {
        super(instance, new ServiceProviderHolder.Builder().setRetrofit(instance.getRetrofit()).setService(ISdkConferenceRService.class).setEventBus(instance.getEventBus()).setClient(instance.getClient()).build());
        this.mInstance = instance;
        this.mConferenceObservableProvider = new ConferenceSdkObservableProvider();
        this.mConferenceObservableProvider.setRetrofitInstantiatedProvider((ISdkConferenceRService)this.getService());
        this.mSDK = instance;
        this.mTimeOutTimer = timeout;
        this.mEventBus = EventBus.getDefault();
        this.mContext = instance.getApplicationContext();
        this.setDefaultBuiltInSpeaker(true);
        this.automaticTelecomModePrefix = AndroidManifest.readMetadata(this.mContext, "voxeet_automatic_telecom_conference_alias_prefix", null);
        this.registerEventBus();
    }

    public boolean mute(boolean mute) {
        MediaSDK media;
        MediaDeviceService service = VoxeetSdk.mediaDevice();
        MediaSDK mediaSDK = media = null != service ? service.getMedia() : null;
        if (null != media) {
            if (!mute && media.isMuted()) {
                if (!Validate.hasMicrophonePermissions(this.context)) {
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                    return false;
                }
                media.unMute();
            } else if (mute) {
                media.mute();
            }
        }
        return true;
    }

    public boolean isMuted() {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        return null == media || media.isMuted();
    }

    @Deprecated
    @NoDocumentation
    public boolean isUserMuted(String userId) {
        return false;
    }

    @Deprecated
    public void toggleVideo() {
        Promise<Boolean> promise = this.isVideoOn() ? this.stopVideo() : this.startVideo();
        promise.then(new PromiseExec<Boolean, Object>(){

            @Override
            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onSuccess: toggleVideo " + result));
            }
        }).error(this.manageError());
    }

    @Deprecated
    public void toggleScreenShare() {
        if (this.isScreenShareOn()) {
            this.stopScreenShare().then(new PromiseExec<Boolean, Object>(){

                @Override
                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onSuccess: toggleScreenShare " + result));
                }
            }).error(this.manageError());
        } else {
            VoxeetSdk.screenShare().sendRequestStartScreenShare();
        }
    }

    @Nullable
    public String currentSpeaker() {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        Conference conference = this.getConference();
        if (null == media || conference == null) {
            return VoxeetSdk.session().getUserId();
        }
        String currentSpeaker = null;
        for (User user : conference.getUsers()) {
            if (user.getId() == null || user.getId().equals(VoxeetPreferences.id()) || !ConferenceUserStatus.ON_AIR.equals((Object)user.getStatus())) continue;
            double peerVuMeter = media.getPeerVuMeter(user.getId());
            if (Double.isNaN(peerVuMeter)) {
                peerVuMeter = 0.0;
            }
            if (currentSpeaker != null && (!(peerVuMeter > 0.001) || !(media.getPeerVuMeter(currentSpeaker) < peerVuMeter))) continue;
            currentSpeaker = user.getId();
        }
        return currentSpeaker;
    }

    @NonNull
    private String currentUserOrEmpty() {
        String currentUserId = VoxeetPreferences.id();
        return null != currentUserId ? currentUserId : "";
    }

    @Nullable
    public User findUserById(String userId) {
        Conference conference = this.getConference();
        return null != conference ? conference.findUserById(userId) : null;
    }

    public void setTelecomMode(boolean telecomMode) {
        this.telecomMode = telecomMode;
        ConferenceInformation currentConference = this.getCurrentConferenceInformation();
        if (null != currentConference) {
            currentConference.setTelecomMode(telecomMode);
        }
    }

    public boolean isTelecomMode() {
        return this.telecomMode;
    }

    @Nullable
    public String getAutomaticTelecomModePrefix() {
        return this.automaticTelecomModePrefix;
    }

    @Nullable
    public String getConferenceId() {
        return this.mConferenceId;
    }

    public long getTimeout() {
        return this.mTimeOutTimer;
    }

    public void toggleRecording() {
        Promise<Boolean> promise = this.isRecording ? this.stopRecording() : this.startRecording();
        promise.then(new PromiseExec<Boolean, Object>(){

            @Override
            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onSuccess: toggle done " + result));
            }
        }).error(new ErrorPromise(){

            @Override
            public void onError(Throwable error) {
                error.printStackTrace();
            }
        });
    }

    @Deprecated
    public boolean muteUser(@NonNull String userId, boolean shouldMute) {
        return false;
    }

    @Deprecated
    public boolean isVideoOn() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        return null != information && information.isOwnVideoStarted();
    }

    @Deprecated
    public boolean isScreenShareOn() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        return null != information && information.isScreenShareOn();
    }

    @Deprecated
    public boolean setDefaultVideo(boolean default_state) {
        return false;
    }

    public boolean setDefaultMute(boolean default_state) {
        this.isDefaultMute = default_state;
        return true;
    }

    public boolean setDefaultBuiltInSpeaker(boolean default_state) {
        this.isDefaultOnSpeaker = default_state;
        VoxeetPreferences.setDefaultBuiltInSpeakerOn(default_state);
        return true;
    }

    public boolean setTimeOut(long timeout) {
        this.mTimeOutTimer = timeout;
        return true;
    }

    @Deprecated
    public boolean setUserPosition(String userId, double angle, double distance) {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null != media) {
            ConferenceInformation conference = this.getCurrentConferenceInformation();
            if (null != conference) {
                UserPosition position = conference.getPosition(userId);
                position.angle = angle;
                position.distance = distance;
                conference.setPosition(userId, position);
            }
            media.changePeerPosition(userId, angle, distance);
            return true;
        }
        return false;
    }

    @NonNull
    public LocalConferenceType getConferenceType() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null == information || null == this.mConferenceId) {
            return LocalConferenceType.NONE;
        }
        return information.getConferenceType();
    }

    @Nullable
    public Conference getConference() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null == information) {
            return null;
        }
        return information.getConference();
    }

    public boolean isInConference() {
        return this.mInConference;
    }

    void setIsInConference(boolean status) {
        this.mInConference = status;
    }

    public double getPeerVuMeter(@Nullable String peerId) {
        Validate.runningOnUiThread();
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null != media && null != peerId) {
            return media.getPeerVuMeter(peerId);
        }
        return 0.0;
    }

    @NonNull
    public List<User> getConferenceUsers() {
        Conference conference = this.getConference();
        if (null == conference) {
            Log.d((String)TAG, (String)"getConferenceUsers: returning a new instance :: NOT IN A CONFERENCE");
            return new ArrayList<User>();
        }
        return conference.getUsers();
    }

    @NonNull
    public List<User> getLastInvitationUsers() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null == information) {
            return new ArrayList<User>();
        }
        return information.getLastInvitationReceived();
    }

    public boolean isLive() {
        return null != this.getConference();
    }

    @NonNull
    public ConferenceService cancelTimeout() {
        this.removeTimeoutCallbacks();
        return this;
    }

    @NonNull
    public Promise<DeclineConferenceResultEvent> decline(String conferenceId) {
        return new DeclinePromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId).createPromise();
    }

    @Deprecated
    public void sendRequestStartScreenShare() {
        VoxeetSdk.screenShare().sendRequestStartScreenShare();
    }

    public void onUserCanceledScreenShare() {
        ConferenceInformation information;
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null != media) {
            media.stopScreenCapturer();
        }
        if (null != (information = this.getCurrentConferenceInformation())) {
            information.setScreenShareOn(false);
        }
    }

    @NonNull
    public Promise<Boolean> startScreenShare(@NonNull Intent intent, int width, int height) {
        return new StartScreensharePromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus(), intent, width, height).createPromise();
    }

    @NonNull
    public Promise<Boolean> stopScreenShare() {
        return new StopScreenSharePromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    @NonNull
    public Promise<Boolean> startVideo() {
        CameraContext provider = VoxeetSdk.mediaDevice().getCameraContext();
        return this.startVideo(provider.isDefaultFrontFacing());
    }

    @NonNull
    public Promise<Boolean> startVideo(boolean isDefaultFrontFacing) {
        return new StartVideoPromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus(), isDefaultFrontFacing).createPromise();
    }

    public Promise<Boolean> stopVideo() {
        return new StopVideoPromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    Promise<Boolean> createVideoAnswer(final @NonNull String userId, final @Nullable OfferDescription offerDescription, final List<OfferCandidate> offerCandidates) {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
                String sdp = "";
                String type = "";
                if (null != offerDescription) {
                    sdp = offerDescription.sdp;
                    type = offerDescription.type;
                }
                try {
                    if (null == media) {
                        throw new MediaEngineException("media is null");
                    }
                }
                catch (MediaEngineException exception) {
                    solver.reject(exception);
                }
                if (null == offerDescription) {
                    ConferenceService.this.stopVideo().execute();
                    Log.d((String)TAG, (String)"onCall: unable to start video, are you a listener?");
                    solver.resolve(false);
                    return;
                }
                SdpDescription description = new SdpDescription(type, sdp);
                ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
                if (offerCandidates != null) {
                    for (OfferCandidate candidate : offerCandidates) {
                        candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                    }
                }
                ConferenceService.this.createAnswerForPeerThreaded(media, userId, description.ssrc, description, candidates, userId.equals(VoxeetSdk.session().getUserId())).then(new PromiseExec<SdpMessage, Object>(){

                    @Override
                    public void onCall(@Nullable SdpMessage message, @NonNull Solver<Object> internal_solver) {
                        Log.d((String)TAG, (String)("onMessage: having a message " + message));
                        ConferenceService.this.answer(userId, message).then(new PromiseExec<Integer, Object>(){

                            @Override
                            public void onCall(@Nullable Integer result, @NonNull Solver<Object> internal_solver) {
                                Log.d((String)TAG, (String)("onSuccess: " + result));
                                solver.resolve(true);
                            }
                        }).error(new ErrorPromise(){

                            @Override
                            public void onError(Throwable error) {
                                if (error instanceof PromiseParticipantAddedErrorEventException) {
                                    ConferenceService.this.mEventBus.post((Object)((PromiseParticipantAddedErrorEventException)error).getEvent());
                                } else {
                                    error.printStackTrace();
                                }
                                solver.resolve(false);
                            }
                        });
                    }
                }).error(new ErrorPromise(){

                    @Override
                    public void onError(@NonNull Throwable error) {
                        error.printStackTrace();
                        solver.reject(error);
                    }
                });
            }
        });
    }

    public Promise<CreateConferenceResult> create(@Nullable String conferenceAlias) {
        return this.create(new ConferenceCreateInformation.Builder().setConferenceAlias(conferenceAlias).build());
    }

    @Deprecated
    public Promise<CreateConferenceResult> create(@Nullable String conferenceAlias, @Nullable MetadataHolder metadata, @Nullable ParamsHolder paramsholder) {
        return this.create(new ConferenceCreateInformation.Builder().setConferenceAlias(conferenceAlias).setMetadataHolder(metadata).setParamsHolder(paramsholder).build());
    }

    public Promise<CreateConferenceResult> create(@NonNull ConferenceCreateInformation conferenceCreateInformation) {
        return new CreateConferencePromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus(), conferenceCreateInformation.getConferenceAlias(), conferenceCreateInformation.getMetadataHolder(), conferenceCreateInformation.getParamsHolder()).createPromise();
    }

    public Promise<Boolean> listen(@NonNull String conferenceId) {
        return this.join(new ConferenceJoinInformation.Builder(conferenceId).setConferenceUserType(ConferenceUserType.LISTENER).build());
    }

    public Promise<Boolean> broadcast(@NonNull String conferenceId) {
        return this.join(new ConferenceJoinInformation.Builder(conferenceId).setConferenceUserType(ConferenceUserType.BROADCASTER).build());
    }

    public Promise<Boolean> join(@NonNull String conferenceId) {
        return this.join(new ConferenceJoinInformation.Builder(conferenceId).setConferenceUserType(ConferenceUserType.NORMAL).build());
    }

    private Promise<Boolean> join(@NonNull ConferenceJoinInformation conferenceJoinInformation) {
        return new JoinPromise(this, VoxeetSdk.audio(), VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceJoinInformation.getConferenceId()), this.getEventBus(), this.mInstance, conferenceJoinInformation.getConferenceId(), conferenceJoinInformation.getConferenceUserType()).createPromise();
    }

    public Promise<Boolean> demo() {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<CreateConferenceResult> user = ConferenceService.this.mConferenceObservableProvider.getCreateDemoObservable();
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<CreateConferenceResult>(){

                    @Override
                    public void onSuccess(@NonNull CreateConferenceResult object, @NonNull Response<CreateConferenceResult> response) {
                        solver.resolve(ConferenceService.this.listen(((CreateConferenceResult)response.body()).conferenceId));
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<CreateConferenceResult> response) {
                        HttpException.dumpErrorResponse(response);
                        ConferenceService.this.mEventBus.post((Object)new ConferenceCreatedError(ConferenceService.this.handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @NonNull
    public Promise<List<User>> invite(final String conferenceId, final List<UserInfo> userInfos) {
        return new Promise<List<User>>(new PromiseSolver<List<User>>(){

            @Override
            public void onCall(@NonNull Solver<List<User>> solver) {
                List<User> users = ConferenceService.this.getConferenceUsers();
                ArrayList<String> strings = new ArrayList<String>();
                if (null != userInfos) {
                    for (UserInfo info : userInfos) {
                        if (null == info || info.getExternalId() == null) continue;
                        for (int i = 0; i < users.size(); ++i) {
                            User user = users.get(i);
                            if (null == user || null == user.getUserInfo() || !info.getExternalId().equalsIgnoreCase(user.getUserInfo().getExternalId())) continue;
                            user.updateIfNeeded(info.getName(), info.getAvatarUrl());
                        }
                        strings.add(info.getExternalId());
                    }
                }
                solver.resolve(new InvitePromise(ConferenceService.this, VoxeetSdk.mediaDevice(), ConferenceService.this.mConferenceObservableProvider, ConferenceService.this.getCurrentConferenceInformation(), ConferenceService.this.getEventBus(), conferenceId, strings).createPromise());
            }
        });
    }

    public Promise<Boolean> replay(String conferenceId, long offset) {
        return new ReplayPromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId, offset).createPromise();
    }

    public Promise<Boolean> startRecording() {
        return new StartRecordingPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> stopRecording() {
        return new StopRecordingPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    public Promise<ConferenceStatusResult> getConferenceStatus(String conferenceId) {
        return new GetConferenceStatusPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    public Promise<GetConferenceHistoryResult> conferenceHistory(String conferenceId) {
        return new GetConferenceHistoryPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> subscribe(@NonNull String conferenceId) {
        return new SubscribeConferenceEventPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> unSubscribe(@NonNull String conferenceId) {
        return new UnsubscribeConferenceEventPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> subscribeForCall(String conferenceId) {
        return new SubscribeForCallStartPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> unSubscribeFromCall(String conferenceId) {
        return new UnsubscribeForCallStartPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(@NonNull OwnConferenceUserSwitch switchEvent) {
        Log.d((String)TAG, (String)("onEvent: OwnConferenceUserSwitch : type ? " + switchEvent.getType()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(@NonNull SocketConnectEvent event) {
        String conferenceId = this.getConferenceId();
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null != conferenceId && null != information && ConferenceState.JOINED.equals((Object)information.getConferenceState())) {
            if (this.isICERestartEnabled()) {
                Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined <3");
                Call<ResponseBody> user = this.mConferenceObservableProvider.iceRestart(conferenceId);
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined responded <3");
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined error </3");
                        HttpException.dumpErrorResponse(response);
                    }
                });
            } else {
                Log.d((String)TAG, (String)"onEvent: socket state opened while in conference but no isICERestartEnabled() = true. A reconnect may be longer");
            }
        } else {
            ConferenceState state = ConferenceState.DEFAULT;
            if (null != information) {
                state = information.getConferenceState();
            }
            Log.d((String)TAG, (String)("onEvent: SocketConnectEvent not rejoined </3 " + (Object)((Object)state) + " " + conferenceId));
        }
    }

    @NonNull
    private Promise<Boolean> joinVoxeetConference(final @NonNull String conferenceId) {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(@NonNull Solver<Boolean> solver) {
                String existingConferenceId = ConferenceService.this.getConferenceId();
                Log.d((String)TAG, (String)("onCall: " + ConferenceService.this.mInConference + " " + existingConferenceId + " " + conferenceId));
                if (ConferenceService.this.mInConference && (null == existingConferenceId || !existingConferenceId.equals(conferenceId))) {
                    try {
                        throw new InConferenceException();
                    }
                    catch (InConferenceException exception) {
                        solver.reject(exception);
                        return;
                    }
                }
                ConferenceService.this.removeTimeoutCallbacks();
                Log.d((String)TAG, (String)("joining " + conferenceId));
                ConferenceService.this.setIsInConference(true);
                ConferenceService.this.mConferenceId = conferenceId;
                ConferenceInformation information = ConferenceService.this.getCurrentConferenceInformation();
                if (null != information) {
                    solver.resolve(ConferenceService.this.joinConferenceInternalPackage(information));
                } else {
                    Log.d((String)TAG, (String)"onCall: WARNING :: IMPROPER RESULT !!");
                    solver.resolve(false);
                }
            }
        });
    }

    void setCurrentConferenceIfNotInPreviousConference(@NonNull ConferenceInformation conference) {
        boolean canOverride;
        String conferenceId = conference.getConference().getId();
        boolean invalidId = null == conferenceId;
        boolean inConference = this.isInConference();
        boolean sameConference = null == this.mConferenceId || this.mConferenceId.equals(conferenceId);
        boolean bl = canOverride = !inConference || sameConference;
        if (!invalidId && canOverride) {
            this.mConferenceId = conferenceId;
        }
        Log.d((String)TAG, (String)("setCurrentConferenceIfNotInPreviousConference:  invalidId = " + invalidId + " inConference = " + inConference + " sameConference = " + sameConference + " (" + this.mConferenceId + " " + conferenceId + ")  canOverride = " + canOverride + " mConferenceId = " + this.mConferenceId));
    }

    @NonNull
    Promise<Boolean> joinConferenceInternalPackage(final @NonNull ConferenceInformation conference) {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                boolean isSuccess;
                String conferenceId = conference.getConference().getId();
                boolean invalidId = null == conferenceId;
                boolean inConference = ConferenceService.this.isInConference();
                boolean sameConference = null == ConferenceService.this.mConferenceId || ConferenceService.this.mConferenceId.equals(conferenceId);
                Log.d((String)TAG, (String)("onCall: join conference " + conference + " invalidId:=" + invalidId + " inConference:=" + inConference + " sameConference:=" + sameConference + " canOverride:=" + (inConference && !sameConference) + " mConferenceId:=" + ConferenceService.this.mConferenceId + " conferenceId:=" + conferenceId));
                Log.d((String)TAG, (String)"onCall: Not checking for conference joined. Method internally used -- in case of regression please contact support for this specific");
                if (invalidId) {
                    try {
                        throw new InConferenceException();
                    }
                    catch (InConferenceException exception) {
                        solver.reject(exception);
                        return;
                    }
                }
                ConferenceService.this.removeTimeoutCallbacks();
                Log.d((String)TAG, (String)("joining " + conferenceId));
                ConferenceService.this.setIsInConference(true);
                ConferenceService.this.mConferenceId = conferenceId;
                conference.setConferenceState(ConferenceState.JOINING);
                AudioService service = VoxeetSdk.audio();
                if (null != service) {
                    service.enableAec(true);
                    service.enableNoiseSuppressor(true);
                }
                if (!(isSuccess = ConferenceService.this.initMedia(conference.isListener()))) {
                    Log.d((String)TAG, (String)"onCall: InitMedia failed... new state = left");
                    try {
                        ConferenceService.this.setIsInConference(false);
                        conference.setConferenceState(ConferenceState.LEFT);
                        ConferenceService.this.closeMedia();
                        ConferenceJoinedError error = new ConferenceJoinedError(ConferenceService.this.handleError(null));
                        ConferenceService.this.mEventBus.post((Object)error);
                        throw new PromiseConferenceJoinedErrorException(error, null);
                    }
                    catch (PromiseConferenceJoinedErrorException exception) {
                        solver.reject(exception);
                        return;
                    }
                }
                ConferenceService.this.mEventBus.post((Object)new ConferencePreJoinedEvent(conference.getConference()));
                Call<ResumeConference> user = ConferenceService.this.mConferenceObservableProvider.joinConference(conferenceId, new JoinParameters(DeviceType.ANDROID, conference.isListener()));
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResumeConference>(){

                    @Override
                    public void onSuccess(@NonNull ResumeConference object, @NonNull Response<ResumeConference> response) {
                        ConferenceService.this.createOrSetConferenceWithParams(object.getConferenceId(), object.getConferenceAlias());
                        ConferenceService.this.initMedia(conference.isListener());
                        String automaticTelecomModePrefix = ConferenceService.this.getAutomaticTelecomModePrefix();
                        boolean hasAutomaticPrefix = null != automaticTelecomModePrefix && !TextUtils.isEmpty((CharSequence)automaticTelecomModePrefix);
                        Log.d((String)TAG, (String)("onSuccess: trying to join conference, will an attempt to be telecom be made ? " + hasAutomaticPrefix));
                        ConferenceInformation information = ConferenceService.this.getCurrentConferenceInformation();
                        if (null != information) {
                            if (hasAutomaticPrefix && !TextUtils.isEmpty((CharSequence)object.getConferenceAlias()) && object.getConferenceAlias().startsWith(automaticTelecomModePrefix)) {
                                Log.d((String)TAG, (String)"onSuccess: the conference is now in telecom mode");
                                information.setTelecomMode(true);
                            } else {
                                Log.d((String)TAG, (String)"onSuccess: the prefix does not match - if the telecom mode is required, it must be done programmatically at this point");
                            }
                            information.setConferenceState(ConferenceState.JOINED);
                        }
                        ConferenceService.this.onConferenceResumedInternal(object, solver);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResumeConference> response) {
                        HttpException.dumpErrorResponse(response);
                        try {
                            e.printStackTrace();
                            ConferenceService.this.setIsInConference(false);
                            conference.setConferenceState(ConferenceState.LEFT);
                            ConferenceService.this.closeMedia();
                            ConferenceJoinedError error = new ConferenceJoinedError(ConferenceService.this.handleError(e));
                            ConferenceService.this.mEventBus.post((Object)error);
                            throw new PromiseConferenceJoinedErrorException(error, e);
                        }
                        catch (PromiseConferenceJoinedErrorException exception) {
                            solver.reject(exception);
                            return;
                        }
                    }
                });
            }
        });
    }

    private void onConferenceResumedInternal(@NonNull ResumeConference response, final @NonNull Solver<Boolean> solver) {
        this.mConferenceId = response.getConferenceId();
        ConferenceInformation information = this.getCurrentConferenceInformation();
        Conference conference = information.getConference();
        conference.setConferenceId(response.getConferenceId());
        conference.setConferenceAlias(response.getConferenceId());
        if (response.getConferenceAlias() != null) {
            conference.setConferenceAlias(response.getConferenceAlias());
        }
        information.participantsToConferenceUsers(response.getParticipants());
        this.setIsInConference(true);
        VoxeetSdk.audio().setAudioRoute(AudioRoute.ROUTE_PHONE);
        this.mEventBus.post((Object)new ConferenceJoinedSuccessEvent(conference));
        List<Participant> participants = response.getParticipants();
        int length = null != participants ? participants.size() : -1;
        Log.d((String)TAG, (String)("onConferenceResumedInternal: resuming with participants ? " + participants + " " + length));
        if (null != participants) {
            for (Participant participant : participants) {
                Log.d((String)TAG, (String)("onConferenceResumedInternal: call onUserAddedOrUpdated " + participant));
                this.onUserAddedOrUpdated(conference.getId(), participant.getParticipantId(), participant.getUserInfos(), ConferenceUserStatus.fromString(participant.getStatus()), true);
            }
        }
        if (null == response.getCandidates() && null == response.getDescription()) {
            Log.d((String)TAG, (String)"onConferenceResumedInternal: candidates + description");
            solver.resolve(true);
            return;
        }
        Log.d((String)TAG, (String)"onConferenceResumedInternal: having candidates and description");
        UserInfo info = VoxeetSdk.session().getUserInfo();
        String name = "";
        String externalId = "";
        String avatarUrl = "";
        String userId = "";
        if (null != info) {
            userId = VoxeetPreferences.id();
            name = info.getName();
            externalId = info.getExternalId();
            avatarUrl = info.getAvatarUrl();
        }
        this.handleAnswer(response.getConferenceId(), userId != null ? userId : "", externalId, name, avatarUrl, "ANDROID", true, response.getDescription(), response.getCandidates()).then(new PromiseExec<Boolean, Object>(){

            @Override
            public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> s) {
                Log.d((String)TAG, (String)("onCall: answer called, result is " + aBoolean + " " + VoxeetPreferences.id()));
                solver.resolve(true);
            }
        }).error(new ErrorPromise(){

            @Override
            public void onError(@NonNull Throwable error) {
                error.printStackTrace();
                ExceptionManager.sendException(error);
                solver.reject(error);
            }
        });
    }

    @NonNull
    public Promise<ConferenceUsersInvitedResult> getInvitedUsers(@NonNull String conferenceId) {
        return new GetConferenceStatus(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @NonNull
    public Promise<Boolean> sendMessage(@NonNull String conferenceId, @NonNull String message) {
        return new SendBroadcastMessagePromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId, message).createPromise();
    }

    @NonNull
    public Promise<Boolean> leave() {
        return new LeavePromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(InvitationReceivedEvent invitation) {
        String conferenceId = invitation.getConferenceId();
        if (null == conferenceId && null != invitation.getConference()) {
            conferenceId = invitation.getConference().getConferenceId();
        }
        Log.d((String)TAG, (String)("onEvent: current mConferenceId " + this.mConferenceId + " vs " + invitation.getConferenceId() + " vs " + conferenceId));
        if (null != this.mConferenceId && this.mConferenceId.equals(conferenceId)) {
            Log.d((String)TAG, (String)"onEvent: receiving invitation for our conference, we prevent this");
            return;
        }
        final ConferenceInformation information = this.getConferenceInformation(conferenceId);
        boolean is_own_user = invitation.getUserId().equals(VoxeetPreferences.id());
        ConferenceType type = ConferenceType.fromId(invitation.getConference().getConferenceType());
        if (this.isLive() && null != this.getConferenceId() && this.getConferenceId().equals(conferenceId)) {
            Log.d((String)TAG, (String)"onEvent: receiving invitation for the same conference, invalidate the call");
            return;
        }
        if (!is_own_user || ConferenceType.SCHEDULED.equals((Object)type)) {
            InvitationReceivedEvent.UserInviter inviter = invitation.getInviter();
            List<Invitation> invitations = invitation.getInvitations();
            final User[] foundUser = new User[]{null};
            if (null == information) {
                Log.d((String)TAG, (String)"onEvent: INVALID INFORMATION FOR THE CONFERENCE");
            }
            if (null != inviter && null != inviter.externalId && null != inviter.userId) {
                User inviter_user;
                Log.d((String)TAG, (String)("onEvent: Invitation with inviter " + inviter.userId + " " + inviter.externalId));
                UserInfo info = this.createUserInfo(inviter.nickName, inviter.externalId, inviter.externalAvatarUrl);
                foundUser[0] = inviter_user = new User(inviter.userId, info);
                if (null != information) {
                    information.getLastInvitationReceived().add(inviter_user);
                    information.getUserIdsCached().put(inviter.userId, inviter.externalId);
                }
            } else {
                Log.d((String)TAG, (String)"onEvent: Invitation with invalid inviter");
            }
            String finalConferenceId = conferenceId;
            this.getConferenceStatus(invitation.getConference().getConferenceId()).then(new PromiseExec<ConferenceStatusResult, Object>(){

                @Override
                public void onCall(@Nullable ConferenceStatusResult result, @NonNull Solver<Object> internal_solver) {
                    Log.d((String)TAG, (String)("onSuccess: " + result));
                    if (result.getConferenceUsers().size() > 0) {
                        Log.d((String)TAG, (String)("onEvent: users " + result.getConferenceUsers().size()));
                        String foundExternalId = null;
                        ArrayList<User> merged_list = new ArrayList<User>();
                        for (SdkParticipant sdkParticipant : result.participants) {
                            merged_list.add(new User(sdkParticipant));
                        }
                        merged_list.addAll(ConferenceService.this.getLastInvitationUsers());
                        List<User> list = ConferenceUtils.findUsersMatching(ConferenceService.this.currentUserOrEmpty(), merged_list);
                        for (User conferenceUser : list) {
                            String userId = conferenceUser.getId();
                            if (null != foundExternalId || null == information) continue;
                            String externalId = conferenceUser.getUserInfo().getExternalId();
                            String cachedExternalId = information.getUserIdsCached().get(userId);
                            Log.d((String)TAG, (String)("onEvent: " + userId + " " + externalId + " " + cachedExternalId));
                            if (null == foundUser[0]) {
                                foundUser[0] = conferenceUser;
                            }
                            if (null == userId || null != externalId && !userId.equals(externalId) || null == (externalId = cachedExternalId)) continue;
                            foundExternalId = cachedExternalId;
                        }
                        if (foundUser[0] != null && null == foundExternalId) {
                            foundExternalId = foundUser[0].getId();
                            Log.d((String)TAG, (String)"externalId is null, setting it to userId");
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        if (null != foundUser[0]) {
                            // empty if block
                        }
                        hashMap.put("UserId", null != foundUser[0] ? foundUser[0].getId() : "");
                        hashMap.put("DisplayName", null != foundUser[0] ? foundUser[0].getUserInfo().getName() : "");
                        hashMap.put("NotifType", null != result.getType() ? result.getType() : "");
                        hashMap.put("ExternalId", null != foundUser[0] ? foundExternalId : "");
                        hashMap.put("AvatarUrl", null != foundUser[0] ? foundUser[0].getUserInfo().getAvatarUrl() : "");
                        hashMap.put("ConfId", null != result.conferenceId ? result.conferenceId : "");
                        Intent intent = VoxeetIntentFactory.buildFrom(ConferenceService.this.mContext, VoxeetPreferences.getDefaultActivity(), hashMap);
                        if (intent != null) {
                            ConferenceService.this.mContext.startActivity(intent);
                        }
                        ConferenceService.this.mEventBus.post((Object)new IncomingCallEvent(result.conferenceId));
                    }
                }
            }).error(new ErrorPromise(){

                @Override
                public void onError(@NonNull Throwable error) {
                    error.printStackTrace();
                }
            });
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(OwnConferenceCreated ownConferenceStartedEvent) {
        Conference conference;
        if (null != ownConferenceStartedEvent.conferenceInfos) {
            this.mConferenceId = ownConferenceStartedEvent.conferenceInfos.getConferenceId();
        }
        if (null != (conference = this.getConference())) {
            conference.setConferenceInfos(ownConferenceStartedEvent.conferenceInfos);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(RenegociationEndedEvent event) {
        Log.d((String)TAG, (String)("onEvent: Renegociation " + event.getConferenceId() + " " + event.getType() + " " + event.getAnswerReceived() + " " + event.getOfferSent()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(final OfferCreated offer) {
        String conferenceId;
        Conference conference = this.getConference();
        String string2 = conferenceId = null != conference ? conference.getId() : null;
        if (null != conferenceId && conferenceId.equals(offer.getConferenceId())) {
            User user = this.findUserById(offer.getUserId());
            if (null == user) {
                user = new User(offer.getUserId(), new UserInfo(offer.getName(), offer.getExternalId(), offer.getAvatarUrl()));
                Log.d((String)TAG, (String)("run: WARNING obtained OfferCreated for user which did not existed " + user));
                conference.updateUser(user);
                this.mEventBus.post((Object)new UserAddedEvent(conference, user));
            }
            this.handleAnswer(offer.getConferenceId(), offer.getUserId(), offer.getExternalId(), offer.getName(), offer.getAvatarUrl(), offer.getDevice(), offer.isMaster(), offer.getDescription(), offer.getCandidates()).then(new PromiseExec<Boolean, Object>(){

                @Override
                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onCall: answer called, result is " + aBoolean + " " + offer.getUserId() + " " + VoxeetPreferences.id()));
                }
            }).error(new ErrorPromise(){

                @Override
                public void onError(@NonNull Throwable error) {
                    error.printStackTrace();
                    ExceptionManager.sendException(error);
                }
            });
        } else {
            Log.d((String)TAG, (String)"onEvent: OfferCreated for another conference");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantAdded event) {
        this.onUserAddedOrUpdated(event.conferenceId, event.userId, new UserInfo(event.name, event.externalId, event.avatarUrl), ConferenceUserStatus.fromString(event.status), true);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantUpdated event) {
        this.onUserAddedOrUpdated(event.conferenceId, event.userId, null, ConferenceUserStatus.valueOf(event.status), false);
    }

    private void onUserAddedOrUpdated(@NonNull String conferenceId, @NonNull String userId, @Nullable UserInfo userInfo, @NonNull ConferenceUserStatus status, boolean added) {
        boolean timeout_triggered;
        boolean known_user = false;
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        Conference conference = null;
        User user = this.findUserById(userId);
        ConferenceInformation information = this.getConferenceInformation(conferenceId);
        if (null != information) {
            conference = information.getConference();
            user = conference.findUserById(userId);
            if (null != user) {
                known_user = true;
                if (added && null != userInfo) {
                    user.setUserInfo(userInfo);
                }
            } else {
                user = new User(userId, userInfo);
                conference.updateUser(user);
            }
        }
        if (user != null) {
            user.updateStatus(status);
        }
        this.updateConferenceFromUsers();
        switch (status) {
            case CONNECTING: {
                if (null == user || user.getId().equals(VoxeetSdk.session().getUserId())) break;
                Log.d((String)TAG, (String)"Cancelling timeout timer from user connecting");
                this.removeTimeoutCallbacks();
                break;
            }
            case LEFT: 
            case DECLINE: {
                if (null == media || user == null) break;
                user.streamsHandler().removeAllStreams();
                Log.d((String)TAG, (String)("In mConference user with id: " + user + " status updated to " + (Object)((Object)status)));
                media.removePeer(userId);
                break;
            }
            default: {
                Log.d((String)TAG, (String)("status not managed updated to " + (Object)((Object)status)));
            }
        }
        boolean bl = timeout_triggered = null != this.timeoutRunnable && this.timeoutRunnable.isTriggered();
        if (!timeout_triggered) {
            switch (status) {
                case DECLINE: {
                    if (!userId.equals(VoxeetSdk.session().getUserId())) {
                        Log.d((String)TAG, (String)("Conference user with id: " + userId + " declined the call"));
                        this.mEventBus.post((Object)new ConferenceUserCallDeclinedEvent(conferenceId, userId, status));
                        break;
                    }
                }
                case LEFT: {
                    this.checkForTelecomEvent(conference.getId(), user.getId());
                }
                default: {
                    this.updateConferenceFromUsers();
                    if (known_user) {
                        this.mEventBus.post((Object)new UserUpdatedEvent(conference, user));
                        break;
                    }
                    this.mEventBus.post((Object)new UserAddedEvent(conference, user));
                }
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUserCallDeclinedEvent event) {
        this.checkForTelecomEvent(event.conferenceId, event.userId);
    }

    private void checkForTelecomEvent(String conferenceId, String userId) {
        ConferenceInformation currentConference = this.getCurrentConferenceInformation();
        Log.d((String)TAG, (String)("checkForTelecomEvent: having currentConference ? " + currentConference));
        if (null != currentConference && currentConference.isTelecomMode()) {
            Conference conference = currentConference.getConference();
            if (null != conferenceId && conferenceId.equals(conference.getId())) {
                String id = VoxeetPreferences.id();
                if (!TextUtils.isEmpty((CharSequence)userId) && null != id && !id.equals(userId)) {
                    this.leave().then(new PromiseExec<Boolean, Object>(){

                        @Override
                        public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                            Log.d((String)TAG, (String)"onCall: conference left since declined/left event");
                        }
                    }).error(new ErrorPromise(){

                        @Override
                        public void onError(@NonNull Throwable error) {
                            Log.e((String)TAG, (String)"onError: conference left since declined/left event", (Throwable)error);
                        }
                    });
                }
            }
        } else {
            Log.d((String)TAG, (String)"checkForTelecomEvent: not a telecom mode");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN, priority=999)
    public void onEvent(ConferenceDestroyedPush event) {
        if (null == this.mConferenceId || this.mConferenceId.equals(event.conferenceId)) {
            this.closeMedia();
        } else {
            Log.d((String)TAG, (String)"onEvent: another conference has ended");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN, priority=999)
    public void onEvent(ConferenceEnded event) {
        if (null == this.mConferenceId || this.mConferenceId.equals(event.conferenceId)) {
            this.closeMedia();
        } else {
            Log.d((String)TAG, (String)"onEvent: another conference has ended");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(QualityUpdated event) {
        for (ConferenceUser conferenceUser : event.getUser()) {
            User user = this.findUserById(conferenceUser.getUserId());
            if (user == null) continue;
            user.setQuality(conferenceUser.getQuality());
            this.mEventBus.post((Object)new ConferenceUserQualityUpdatedEvent(user));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN, priority=999)
    public void onEvent(RecordingStatusUpdateEvent recordingStatusUpdateEvent) {
        String conferenceId = recordingStatusUpdateEvent.conferenceId;
        Log.d((String)TAG, (String)("onEvent: eevnt for " + conferenceId));
        Conference conference = this.getConferenceInformation(conferenceId).getConference();
        User user = this.findUserById(recordingStatusUpdateEvent.userId);
        if (user != null) {
            Conference.RecordingInformation recording = new Conference.RecordingInformation();
            RecordingStatus status = RecordingStatus.valueOf(recordingStatusUpdateEvent.recordingStatus);
            if (status == RecordingStatus.RECORDING) {
                this.isRecording = true;
                recording.setStartRecordTimestamp(new Date(recordingStatusUpdateEvent.timeStamp));
                recording.setRecordingStatus(RecordingStatus.RECORDING);
                recording.setRecordingUser(recordingStatusUpdateEvent.userId);
            } else {
                this.isRecording = false;
                recording.setStartRecordTimestamp(null);
                recording.setRecordingStatus(RecordingStatus.NOT_RECORDING);
                recording.setRecordingUser(null);
            }
            conference.setRecordingInformation(recording);
        }
    }

    @NonNull
    protected User createConferenceUser(String userId, String device, UserInfo userInfo) {
        return new User(userId, userInfo);
    }

    @NonNull
    protected UserInfo createUserInfo(String userName, String externalId, String avatarUrl) {
        return new UserInfo(userName, externalId, avatarUrl);
    }

    protected void setConference(@NonNull Conference conference) {
        this.mConferenceId = conference.getId();
        ConferenceInformation information = this.getCurrentConferenceInformation();
        information.setConference(conference);
    }

    protected void setConferenceAlias(String alias) {
        Conference conference = this.getConference();
        conference.setConferenceAlias(alias);
    }

    protected boolean isSDK() {
        return true;
    }

    protected Promise<Integer> answer(final String peer, final SdpMessage message) {
        return new Promise<Integer>(new PromiseSolver<Integer>(){

            @Override
            public void onCall(final @NonNull Solver<Integer> solver) {
                try {
                    if (null == ConferenceService.this.mConferenceId) {
                        throw new NotInConferenceException();
                    }
                }
                catch (NotInConferenceException exception) {
                    solver.reject(exception);
                    return;
                }
                Log.d((String)"SDKMEDIA", (String)("answer: peer := " + peer + " message := " + message));
                Call<ResponseBody> user = ConferenceService.this.mConferenceObservableProvider.answerConference(ConferenceService.this.mConferenceId, peer, message.getDescription());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        if (response.code() != 200) {
                            try {
                                ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent(response.code() + "");
                                throw new PromiseParticipantAddedErrorEventException(event);
                            }
                            catch (PromiseParticipantAddedErrorEventException exception) {
                                solver.reject(exception);
                            }
                        } else {
                            solver.resolve(response.code());
                        }
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        try {
                            ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent(ConferenceService.this.handleError(e));
                            throw new PromiseParticipantAddedErrorEventException(event);
                        }
                        catch (PromiseParticipantAddedErrorEventException exception) {
                            solver.reject(exception);
                            return;
                        }
                    }
                });
            }
        });
    }

    protected Promise<Boolean> handleAnswer(final @NonNull String conferenceId, final @NonNull String userId, final @NonNull String externalId, final @NonNull String userName, final @NonNull String avatarUrl, @NonNull String device, final boolean isMaster, final @NonNull OfferDescription offerDescription, final @NonNull List<OfferCandidate> offerCandidates) {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
                if (null == media) {
                    try {
                        throw new MediaEngineException("handleAnswer media is null");
                    }
                    catch (MediaEngineException exception) {
                        solver.reject(exception);
                    }
                }
                if (!conferenceId.equals(ConferenceService.this.mConferenceId)) {
                    Log.d((String)TAG, (String)"onCall: CONFERENCE IS NOT THE SAME ! ANSWER SHALL BE DISCARDED");
                }
                SdpDescription description = new SdpDescription(offerDescription.type, offerDescription.sdp);
                ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
                for (OfferCandidate candidate : offerCandidates) {
                    Log.d((String)TAG, (String)("onCall: sdpcandidate " + candidate.getMid() + " " + candidate.getmLine()));
                    candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                }
                Log.d((String)TAG, (String)("handleAnswer: offer := " + userId + " " + externalId));
                Log.d((String)"SDKMEDIA", (String)("handleAnswer: " + userId + " " + externalId + " " + description.ssrc));
                ConferenceService.this.createAnswerForPeerThreaded(media, userId, description.ssrc, description, candidates, isMaster).then(new PromiseExec<SdpMessage, Object>(){

                    @Override
                    public void onCall(@Nullable SdpMessage message, @NonNull Solver<Object> internal_solver) {
                        try {
                            if (null == ConferenceService.this.mConferenceId) {
                                Log.d((String)TAG, (String)"onMessage: INVALID CONFERENCE ID WHEN OFFER IS RECEIVED");
                                ConferenceService.this.mConferenceId = conferenceId;
                            }
                            Conference conference = ConferenceService.this.getConference();
                            User user = null;
                            for (User in_conf : conference.getUsers()) {
                                if (in_conf.getId() == null || !in_conf.getId().equals(userId)) continue;
                                user = in_conf;
                            }
                            UserInfo infos = userId.contains("11111") ? ConferenceService.this.createUserInfo("Julie", externalId, "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_1.png") : (userId.contains("22222") ? ConferenceService.this.createUserInfo("Sophie", externalId, "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_2.png") : (userId.contains("33333") ? ConferenceService.this.createUserInfo("Mike", externalId, "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_3.png") : ConferenceService.this.createUserInfo(userName, externalId, avatarUrl)));
                            if (user == null) {
                                user = new User(userId, infos);
                                conference.updateUser(user);
                            } else {
                                user.setUserInfo(infos);
                            }
                            ConferenceService.this.setUserPosition(userId, 0.0, 0.5);
                            ConferenceService.this.answer(userId, message).then(new PromiseExec<Integer, Object>(){

                                @Override
                                public void onCall(@Nullable Integer result, @NonNull Solver<Object> internal_solver) {
                                    Log.d((String)TAG, (String)("onSuccess: " + result));
                                    solver.resolve(true);
                                }
                            }).error(new ErrorPromise(){

                                @Override
                                public void onError(Throwable error) {
                                    if (error instanceof PromiseParticipantAddedErrorEventException) {
                                        ConferenceService.this.mEventBus.post((Object)((PromiseParticipantAddedErrorEventException)error).getEvent());
                                    } else {
                                        error.printStackTrace();
                                    }
                                    solver.resolve(false);
                                }
                            });
                        }
                        catch (Exception e) {
                            Log.d((String)TAG, (String)("onMessage: unlockPeerOperation" + e.getMessage()));
                            solver.resolve(false);
                        }
                    }
                }).error(new ErrorPromise(){

                    @Override
                    public void onError(@NonNull Throwable error) {
                        error.printStackTrace();
                        solver.reject(error);
                    }
                });
            }
        });
    }

    protected User updateConferenceParticipants(String userId, ConferenceUserStatus status) {
        User user = this.findUserById(userId);
        Conference conference = this.getConference();
        if (null != user && null != conference) {
            user.updateStatus(status);
            return user;
        }
        return null;
    }

    protected boolean initMedia(boolean listenerMode) {
        Validate.notNull(this.mContext, "mContext");
        Validate.notNull(VoxeetPreferences.id(), "user id");
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null == media) {
            try {
                if (!listenerMode && !Validate.hasMicrophonePermissions(this.context)) {
                    Log.d((String)TAG, (String)"the app does not seem to have mic permission, disabling mic");
                    this.mute(true);
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                    return false;
                }
                VoxeetSdk.audio().enable();
                VoxeetSdk.mediaDevice().createMedia(this.context, VoxeetPreferences.id(), this.mediaStreamListener, this.cameraEventsHandler, this.isDefaultVideo || this.isVideoOn(), !listenerMode && Validate.hasMicrophonePermissions(this.context));
                media = VoxeetSdk.mediaDevice().getMedia();
                VoxeetSdk.audio().setSpeakerMode(this.isDefaultOnSpeaker);
                VoxeetSdk.audio().unsetMediaRoute().requestAudioFocus();
                if (this.isDefaultMute) {
                    media.mute();
                } else {
                    media.unMute();
                }
            }
            catch (MediaEngineException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected void closeMedia() {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null != media) {
            Conference conference = this.getConference();
            ConferenceInformation information = this.getCurrentConferenceInformation();
            if (null != information) {
                information.setOwnVideoStarted(false);
                information.setScreenShareOn(false);
            }
            try {
                if (null != conference) {
                    for (User user : conference.getUsers()) {
                        if (user == null || user.getId() == null) continue;
                        media.removePeer(user.getId());
                    }
                }
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Error", (Throwable)ex);
            }
            VoxeetSdk.audio().abandonAudioFocusRequest().setMediaRoute().disable();
            VoxeetSdk.mediaDevice().releaseMedia();
            media.unsetStreamListener();
        }
        this.setIsInConference(false);
        this.mConferenceId = null;
    }

    protected void removeTimeoutCallbacks() {
        if (this.timeoutRunnable != null) {
            this.timeoutRunnable.setCanceled(true);
            handler.removeCallbacks((Runnable)this.timeoutRunnable);
        }
    }

    protected void sendTimeoutCallbacks() {
        if (this.mTimeOutTimer != -1L) {
            this.timeoutRunnable = new TimeoutRunnable(this, this.mEventBus, this.mTimeOutTimer);
            handler.postDelayed((Runnable)this.timeoutRunnable, this.mTimeOutTimer);
        }
    }

    protected VoxeetSdk getVoxeetSDK() {
        return this.mSDK;
    }

    @NonNull
    protected ConferenceInformation createOrSetConferenceWithParams(@NonNull String conferenceId, @Nullable String conferenceAlias) {
        Log.d((String)TAG, (String)("createOrSetConferenceWithParams: set conference id := " + conferenceId));
        ConferenceInformation information = this.getConferenceInformation(conferenceId);
        Conference conference = information.getConference();
        conference.setConferenceId(conferenceId);
        if (null != conferenceAlias || null == conference.getAlias()) {
            conference.setConferenceAlias(conferenceAlias);
        }
        return information;
    }

    @Nullable
    public ConferenceInformation getCurrentConferenceInformation() {
        return this.getConferenceInformation(this.mConferenceId);
    }

    public boolean hasParticipants() {
        Conference conference = this.getConference();
        return null != conference && conference.hasAny(ConferenceUserStatus.ON_AIR, false);
    }

    public void setICERestartEnabled(boolean new_state) {
        this.isICERestartEnabled = new_state;
    }

    public boolean isICERestartEnabled() {
        return this.isICERestartEnabled;
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    @Nullable
    protected ConferenceInformation getConferenceInformation(@Nullable String conferenceId) {
        if (null == conferenceId) {
            return null;
        }
        return this.mConferenceInformationHolder.getInformation(conferenceId);
    }

    void joinLock() {
        try {
            this.joinLock.lock();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void joinUnlock() {
        try {
            if (this.joinLock.isLocked()) {
                this.joinLock.unlock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateConferenceFromUsers() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null != information) {
            ConferenceState state = information.getConferenceState();
            switch (state) {
                case JOINED: {
                    if (!this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.FIRST_PARTICIPANT);
                    break;
                }
                case FIRST_PARTICIPANT: {
                    if (this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.NO_MORE_PARTICIPANT);
                    break;
                }
                case NO_MORE_PARTICIPANT: {
                    if (!this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.FIRST_PARTICIPANT);
                    break;
                }
            }
            ConferenceState conferenceState = information.getConferenceState();
        }
    }

    @NonNull
    private ErrorPromise manageError() {
        return new ErrorPromise(){

            @Override
            public void onError(@NonNull Throwable error) {
                error.printStackTrace();
            }
        };
    }

    @Nullable
    private String getUserId() {
        SessionService sessionService = VoxeetSdk.session();
        return null != sessionService ? sessionService.getUserId() : null;
    }

    void clearConferencesInformation() {
        this.mConferenceInformationHolder.clearConferencesInformation();
    }

    @NoDocumentation
    public void moveConference(@NonNull String conferenceId, @NonNull ConferenceInformation conferenceInformation) {
        Log.d((String)TAG, (String)("moveConference: change " + conferenceInformation.getConference().getId() + " to " + conferenceId));
        this.mConferenceInformationHolder.moveConference(conferenceId, conferenceInformation);
    }

    private Promise<SdpMessage> createAnswerForPeerThreaded(final @NonNull MediaSDK media, final @NonNull String userId, final long ssrc, final @NonNull SdpDescription offer, final @NonNull List<SdpCandidate> candidates, final boolean master) {
        return new Promise<SdpMessage>(new PromiseSolver<SdpMessage>(){

            @Override
            public void onCall(final @NonNull Solver<SdpMessage> solver) {
                ConferenceService.this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            media.createAnswerForPeer(userId, ssrc, offer, candidates, master, new PendingPeerCallback(){

                                @Override
                                public void onMessage(@Nullable SdpMessage message) {
                                    solver.resolve(message);
                                }
                            });
                        }
                        catch (MediaEngineException e) {
                            e.printStackTrace();
                            solver.reject(e);
                        }
                    }
                });
            }
        });
    }
}

