package com.voxeet.sdk.models;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The ParticipantNotification model contains information about conference participants from notification event.
 *
 * The developers are responsible for the `ParticipantInfo` element. The ID is provided and managed by the SDK.
 */
@Annotate
public class ParticipantNotification {

    @Nullable
    private String id;

    @Nullable
    private ParticipantInfo participantInfo;

    @NonNull
    private ConferenceParticipantStatus status;
    private String quality; //needed ?

    private ParticipantNotification() {

    }

    @NoDocumentation
    public ParticipantNotification(@Nullable String id, @Nullable ParticipantInfo participantInfo,
                                   @NonNull ConferenceParticipantStatus status) {
        this();
        this.id = id;
        this.participantInfo = participantInfo;
        this.status = status;
    }

    /**
     * Gets the Voxeet identifier of the specific conference participant.
     *
     * @return possibly a null value.
     */
    @Nullable
    public String getId() {
        return id;
    }

    /**
     * Gets information about the current participant.
     *
     * @return displayed information.
     */
    @Nullable
    public ParticipantInfo getInfo() {
        return participantInfo;
    }

    /**
     * Gets the current status.
     *
     * @return the instance of the valid status.
     */
    @NonNull
    public ConferenceParticipantStatus getStatus() {
        return status;
    }

    /**
     * Get the string representation of the given instance
     *
     * @return a valid string
     */
    @NoDocumentation
    @NonNull
    @Override
    public String toString() {
        return "Participant{" +
                "id='" + id + '\'' +
                ", participantInfo=" + participantInfo +
                ", status=" + status +
                ", quality='" + quality + '\'' +
                '}';
    }
}
