/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.ncco.Action;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class StreamAction
extends JsonableBaseObject
implements Action {
    private Collection<URI> streamUrl;
    private Double level;
    private Boolean bargeIn;
    private Integer loop;

    StreamAction() {
    }

    private StreamAction(Builder builder) {
        this.streamUrl = Collections.singleton(URI.create(Objects.requireNonNull(builder.streamUrl, "Stream URL is required")));
        this.level = builder.level;
        this.bargeIn = builder.bargeIn;
        this.loop = builder.loop;
    }

    @Override
    public String getAction() {
        return "stream";
    }

    @JsonProperty(value="streamUrl")
    public Collection<URI> getStreamUrl() {
        return this.streamUrl;
    }

    @JsonProperty(value="level")
    public Double getLevel() {
        return this.level;
    }

    @JsonProperty(value="bargeIn")
    public Boolean getBargeIn() {
        return this.bargeIn;
    }

    @JsonProperty(value="loop")
    public Integer getLoop() {
        return this.loop;
    }

    public static Builder builder(String streamUrl) {
        return StreamAction.builder().streamUrl(streamUrl);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String streamUrl;
        private Double level;
        private Boolean bargeIn;
        private Integer loop;

        Builder() {
        }

        public Builder streamUrl(String streamUrl) {
            this.streamUrl = streamUrl;
            return this;
        }

        public Builder level(double level) {
            this.level = level;
            return this;
        }

        public Builder bargeIn(boolean bargeIn) {
            this.bargeIn = bargeIn;
            return this;
        }

        public Builder loop(int loop) {
            this.loop = loop;
            return this;
        }

        public StreamAction build() {
            return new StreamAction(this);
        }
    }
}

