/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.Jsonable;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.MachineDetection;

public class AdvancedMachineDetection
extends JsonableBaseObject {
    private MachineDetection behavior;
    private Mode mode;
    private Integer beepTimeout;

    AdvancedMachineDetection() {
    }

    AdvancedMachineDetection(Builder builder) {
        this.behavior = builder.behavior;
        this.mode = builder.mode;
        this.beepTimeout = builder.beepTimeout;
        if (this.beepTimeout != null && (this.beepTimeout < 45 || this.beepTimeout > 120)) {
            throw new IllegalArgumentException("Beep timeout must be between 45 and 120 seconds.");
        }
    }

    @JsonProperty(value="behavior")
    public MachineDetection getBehavior() {
        return this.behavior;
    }

    @JsonProperty(value="mode")
    public Mode getMode() {
        return this.mode;
    }

    @JsonProperty(value="beep_timeout")
    public Integer getBeepTimeout() {
        return this.beepTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MachineDetection behavior;
        private Mode mode;
        private Integer beepTimeout;

        Builder() {
        }

        public Builder behavior(MachineDetection behavior) {
            this.behavior = behavior;
            return this;
        }

        public Builder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder beepTimeout(int beepTimeout) {
            this.beepTimeout = beepTimeout;
            return this;
        }

        public AdvancedMachineDetection build() {
            return new AdvancedMachineDetection(this);
        }
    }

    public static enum Mode {
        DETECT,
        DETECT_BEEP,
        DEFAULT;


        @JsonCreator
        public static Mode fromString(String value) {
            return Jsonable.fromString(value, Mode.class);
        }

        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

