/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.vonage.client.AbstractQueryParamsRequest;
import com.vonage.client.video.ArchiveMode;
import com.vonage.client.video.MediaMode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

public class CreateSessionRequest
extends AbstractQueryParamsRequest {
    private final InetAddress location;
    private final MediaMode mediaMode;
    private final ArchiveMode archiveMode;
    private final Boolean e2ee;

    private CreateSessionRequest(Builder builder) {
        this.location = builder.location;
        this.archiveMode = builder.archiveMode;
        this.mediaMode = builder.mediaMode;
        this.e2ee = builder.e2ee;
        if (this.archiveMode == ArchiveMode.ALWAYS && this.mediaMode != MediaMode.ROUTED) {
            throw new IllegalStateException("A session with automatic archiving must also have the ROUTED media mode.");
        }
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        if (this.location != null) {
            params.put("location", this.location.getHostAddress());
        }
        this.conditionalAdd("p2p.preference", (Object)this.mediaMode);
        this.conditionalAdd("archiveMode", (Object)this.archiveMode);
        this.conditionalAdd("e2ee", this.e2ee);
        return params;
    }

    public InetAddress getLocation() {
        return this.location;
    }

    public MediaMode getMediaMode() {
        return this.mediaMode;
    }

    public ArchiveMode getArchiveMode() {
        return this.archiveMode;
    }

    public Boolean getE2ee() {
        return this.e2ee;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private InetAddress location;
        private MediaMode mediaMode;
        private ArchiveMode archiveMode;
        private Boolean e2ee;

        Builder() {
        }

        public Builder location(InetAddress location) {
            this.location = location;
            return this;
        }

        public Builder location(String location) {
            try {
                return this.location(InetAddress.getByName(location));
            }
            catch (UnknownHostException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public Builder mediaMode(MediaMode mediaMode) {
            this.mediaMode = mediaMode;
            return this;
        }

        public Builder archiveMode(ArchiveMode archiveMode) {
            this.archiveMode = archiveMode;
            return this;
        }

        public Builder e2ee(boolean e2ee) {
            this.e2ee = e2ee;
            return this;
        }

        public CreateSessionRequest build() {
            return new CreateSessionRequest(this);
        }
    }
}

