/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.common.E164;
import com.vonage.client.verify2.AbstractNumberWorkflow;
import com.vonage.client.verify2.Channel;

public final class SmsWorkflow
extends AbstractNumberWorkflow {
    final String appHash;
    final String contentId;
    final String entityId;

    SmsWorkflow(Builder builder) {
        super(builder);
        this.appHash = builder.appHash;
        if (this.appHash != null && this.appHash.length() != 11) {
            throw new IllegalArgumentException("Android app hash must be 11 characters.");
        }
        this.contentId = builder.contentId;
        if (this.contentId != null && (this.contentId.isEmpty() || this.contentId.length() > 20)) {
            throw new IllegalArgumentException("content_id must be between 1 and 20 characters long.");
        }
        this.entityId = builder.entityId;
        if (this.entityId != null && (this.entityId.isEmpty() || this.entityId.length() > 20)) {
            throw new IllegalArgumentException("entity_id must be between 1 and 20 characters long.");
        }
    }

    public SmsWorkflow(String to) {
        this(SmsWorkflow.builder(to));
    }

    @Override
    protected String validateFrom(String from) {
        if ((from = super.validateFrom(from)) == null) {
            return null;
        }
        if (from.length() > 11) {
            return new E164(from).toString();
        }
        return from;
    }

    @JsonProperty(value="app_hash")
    public String getAppHash() {
        return this.appHash;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="content_id")
    public String getContentId() {
        return this.contentId;
    }

    @JsonProperty(value="entity_id")
    public String getEntityId() {
        return this.entityId;
    }

    public static Builder builder(String to) {
        return new Builder(to);
    }

    public static final class Builder
    extends AbstractNumberWorkflow.Builder<SmsWorkflow, Builder> {
        private String from;
        private String appHash;
        private String contentId;
        private String entityId;

        private Builder(String to) {
            super(Channel.SMS, to);
        }

        @Override
        public Builder from(String from) {
            return (Builder)super.from(from);
        }

        public Builder appHash(String appHash) {
            this.appHash = appHash;
            return this;
        }

        public Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        @Override
        public SmsWorkflow build() {
            return new SmsWorkflow(this);
        }
    }
}

