/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.vonage.client.QueryParamsRequest;
import java.util.LinkedHashMap;
import java.util.Map;

class SearchRequest
implements QueryParamsRequest {
    private static final int MAX_SEARCH_REQUESTS = 10;
    private final String[] requestIds;

    public SearchRequest(String ... requestIds) {
        if (requestIds.length == 0) {
            throw new IllegalArgumentException("At least one request ID must be provided in a SearchRequest");
        }
        if (requestIds.length > 10) {
            throw new IllegalArgumentException("Too many request IDs. Max is 10");
        }
        this.requestIds = requestIds;
    }

    public String[] getRequestIds() {
        return this.requestIds;
    }

    @Override
    public Map<String, ?> makeParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(this.requestIds.length);
        if (this.requestIds.length == 1) {
            params.put("request_id", this.requestIds[0]);
        } else {
            params.put("request_ids", this.requestIds);
        }
        return params;
    }
}

