/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.users.channels;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.users.channels.Channel;
import com.vonage.client.users.channels.Messenger;
import com.vonage.client.users.channels.Mms;
import com.vonage.client.users.channels.Pstn;
import com.vonage.client.users.channels.Sip;
import com.vonage.client.users.channels.Sms;
import com.vonage.client.users.channels.Vbc;
import com.vonage.client.users.channels.Viber;
import com.vonage.client.users.channels.Websocket;
import com.vonage.client.users.channels.Whatsapp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class Channels
extends JsonableBaseObject {
    @JsonProperty(value="pstn")
    private List<Pstn> pstn;
    @JsonProperty(value="sip")
    private List<Sip> sip;
    @JsonProperty(value="vbc")
    private List<Vbc> vbc;
    @JsonProperty(value="websocket")
    private List<Websocket> websocket;
    @JsonProperty(value="sms")
    private List<Sms> sms;
    @JsonProperty(value="mms")
    private List<Mms> mms;
    @JsonProperty(value="whatsapp")
    private List<Whatsapp> whatsapp;
    @JsonProperty(value="viber")
    private List<Viber> viber;
    @JsonProperty(value="messenger")
    private List<Messenger> messenger;

    Channels() {
    }

    private <C extends Channel> List<C> initChannelList(C firstElement) {
        ArrayList<C> channel = new ArrayList<C>(2);
        channel.add(firstElement);
        return channel;
    }

    public Channels(Collection<? extends Channel> channels) {
        if (channels == null || channels.isEmpty()) {
            return;
        }
        for (Channel channel : channels) {
            if (channel instanceof Pstn) {
                this.pstn = this.initChannelList((Pstn)channel);
                continue;
            }
            if (channel instanceof Sip) {
                this.sip = this.initChannelList((Sip)channel);
                continue;
            }
            if (channel instanceof Vbc) {
                this.vbc = this.initChannelList((Vbc)channel);
                continue;
            }
            if (channel instanceof Websocket) {
                this.websocket = this.initChannelList((Websocket)channel);
                continue;
            }
            if (channel instanceof Sms) {
                this.sms = this.initChannelList((Sms)channel);
                continue;
            }
            if (channel instanceof Mms) {
                this.mms = this.initChannelList((Mms)channel);
                continue;
            }
            if (channel instanceof Whatsapp) {
                this.whatsapp = this.initChannelList((Whatsapp)channel);
                continue;
            }
            if (channel instanceof Viber) {
                this.viber = this.initChannelList((Viber)channel);
                continue;
            }
            if (!(channel instanceof Messenger)) continue;
            this.messenger = this.initChannelList((Messenger)channel);
        }
    }

    public List<Pstn> getPstn() {
        return this.pstn;
    }

    public List<Sip> getSip() {
        return this.sip;
    }

    public List<Vbc> getVbc() {
        return this.vbc;
    }

    public List<Websocket> getWebsocket() {
        return this.websocket;
    }

    public List<Sms> getSms() {
        return this.sms;
    }

    public List<Mms> getMms() {
        return this.mms;
    }

    public List<Whatsapp> getWhatsapp() {
        return this.whatsapp;
    }

    public List<Viber> getViber() {
        return this.viber;
    }

    public List<Messenger> getMessenger() {
        return this.messenger;
    }
}

