/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.users;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.users.BaseUser;
import com.vonage.client.users.ListUsersRequest;
import com.vonage.client.users.ListUsersResponse;
import com.vonage.client.users.User;
import com.vonage.client.users.UsersResponseException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public class UsersClient {
    final RestEndpoint<ListUsersRequest, ListUsersResponse> listUsers;
    final RestEndpoint<User, User> createUser;
    final RestEndpoint<String, User> getUser;
    final RestEndpoint<User, User> updateUser;
    final RestEndpoint<String, Void> deleteUser;

    public UsersClient(final HttpWrapper wrapper) {
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<T, String> pathGetter, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).responseExceptionType(UsersResponseException.class).wrapper(var5_5).requestMethod(method).authMethod(JWTAuthMethod.class, new Class[0]).pathGetter((de, req) -> {
                    String base = de.getHttpWrapper().getHttpConfig().getApiBaseUri() + "/v1";
                    String path = base + "/users";
                    if (pathGetter != null) {
                        path = path + "/" + (String)pathGetter.apply(req);
                    }
                    return path;
                }));
            }
        }
        this.listUsers = new Endpoint(null, HttpMethod.GET, (Object[])new ListUsersResponse[0]);
        this.createUser = new Endpoint(null, HttpMethod.POST, (Object[])new User[0]);
        this.getUser = new Endpoint(Function.identity(), HttpMethod.GET, (Object[])new User[0]);
        this.updateUser = new Endpoint(BaseUser::getId, HttpMethod.PATCH, (Object[])new User[0]);
        this.deleteUser = new Endpoint(Function.identity(), HttpMethod.DELETE, (Object[])new Void[0]);
    }

    private <U extends BaseUser> U validateUser(U request) {
        return Objects.requireNonNull(request, "User is required.");
    }

    private String validateUserId(String id) {
        Objects.requireNonNull(id, "User ID is required.");
        String prefix = "USR-";
        if (!id.startsWith(prefix)) {
            throw new IllegalArgumentException("Invalid user ID.");
        }
        return prefix + UUID.fromString(id.substring(prefix.length()));
    }

    public User createUser(User user) throws UsersResponseException {
        return this.createUser.execute(this.validateUser(user));
    }

    public User updateUser(String userId, User user) throws UsersResponseException {
        this.validateUser(user).id = this.validateUserId(userId);
        return this.updateUser.execute(user);
    }

    public User getUser(String userId) throws UsersResponseException {
        return this.getUser.execute(this.validateUserId(userId));
    }

    public void deleteUser(String userId) throws UsersResponseException {
        this.deleteUser.execute(this.validateUserId(userId));
    }

    public ListUsersResponse listUsers(ListUsersRequest request) throws UsersResponseException {
        return this.listUsers.execute(request != null ? request : ListUsersRequest.builder().build());
    }

    public List<BaseUser> listUsers() throws UsersResponseException {
        return this.listUsers(ListUsersRequest.builder().pageSize(100).build()).getUsers();
    }

    public User getUserDetails(BaseUser minimalUser) {
        return this.getUser(this.validateUser(minimalUser).getId());
    }

    public List<User> getUserDetails(List<BaseUser> minimalUsers) {
        return Objects.requireNonNull(minimalUsers, "Users list is required").stream().map(this::getUserDetails).collect(Collectors.toList());
    }
}

