/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.sms.messages;

import com.vonage.client.AbstractQueryParamsRequest;
import com.vonage.client.sms.messages.MessageClass;
import com.vonage.client.sms.messages.MessageType;
import java.util.Map;

public abstract class Message
extends AbstractQueryParamsRequest {
    private final MessageType type;
    private final String from;
    private final String to;
    private boolean statusReportRequired;
    private MessageClass messageClass;
    private Long timeToLive;
    private String clientReference;
    private String callbackUrl;
    private String entityId;
    private String contentId;

    protected Message(MessageType type, String from, String to) {
        this(type, from, to, false);
    }

    protected Message(MessageType type, String from, String to, boolean statusReportRequired) {
        this.type = type;
        this.from = from;
        this.to = to;
        this.statusReportRequired = statusReportRequired;
    }

    public MessageType getType() {
        return this.type;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getClientReference() {
        return this.clientReference;
    }

    public void setClientReference(String clientReference) {
        if (clientReference.length() > 40) {
            throw new IllegalArgumentException("Client reference must be 40 characters or less.");
        }
        this.clientReference = clientReference;
    }

    public MessageClass getMessageClass() {
        return this.messageClass;
    }

    public void setMessageClass(MessageClass messageClass) {
        this.messageClass = messageClass;
    }

    public Long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public boolean getStatusReportRequired() {
        return this.statusReportRequired;
    }

    public void setStatusReportRequired(boolean statusReportRequired) {
        this.statusReportRequired = statusReportRequired;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        this.conditionalAdd("from", this.from);
        this.conditionalAdd("to", this.to);
        this.conditionalAdd("type", (Object)this.type);
        if (this.getStatusReportRequired()) {
            this.conditionalAdd("status-report-req", "1");
        }
        this.conditionalAdd("client-ref", this.clientReference);
        this.conditionalAdd("ttl", this.timeToLive);
        this.conditionalAdd("callback", this.callbackUrl);
        if (this.messageClass != null) {
            this.conditionalAdd("message-class", this.messageClass.getMessageClass());
        }
        this.conditionalAdd("entity-id", this.entityId);
        this.conditionalAdd("content-id", this.contentId);
        return params;
    }
}

