/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.AbstractQueryParamsRequest;
import com.vonage.client.common.E164;
import java.util.Map;

abstract class BaseNumberRequest
extends AbstractQueryParamsRequest {
    private final String country;
    private final String msisdn;

    protected BaseNumberRequest(String country, String msisdn) {
        this.country = BaseNumberRequest.validateCountry(country);
        this.msisdn = new E164(msisdn).toString();
    }

    public String getCountry() {
        return this.country;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        this.conditionalAdd("country", this.country);
        this.conditionalAdd("msisdn", this.msisdn);
        return params;
    }

    static String validateCountry(String country) {
        if (country == null || country.length() != 2) {
            throw new IllegalArgumentException("Country code is required in ISO 3166-1 alpha-2 format.");
        }
        return country.toUpperCase();
    }
}

