/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.vonage.client.insight.BaseInsightRequest;

public class StandardInsightRequest
extends BaseInsightRequest {
    private StandardInsightRequest(Builder builder) {
        super(builder.number, builder.country);
        this.cnam = builder.cnam;
    }

    public Boolean getCnam() {
        return this.cnam;
    }

    public static StandardInsightRequest withNumber(String number) {
        return new Builder(number).build();
    }

    public static StandardInsightRequest withNumberAndCountry(String number, String country) {
        return new Builder(number).country(country).build();
    }

    public static Builder builder(String number) {
        return new Builder(number);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected String number;
        protected String country;
        protected Boolean cnam;

        protected Builder(String number) {
            this.number = number;
        }

        protected Builder() {
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder cnam(Boolean cnam) {
            this.cnam = cnam;
            return this;
        }

        public StandardInsightRequest build() {
            return new StandardInsightRequest(this);
        }
    }
}

