/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.common.MessageType;
import com.vonage.client.conversations.Location;
import com.vonage.client.conversations.MessageEvent;
import com.vonage.client.conversations.WhatsappTemplate;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

class MessageEventBody
extends JsonableBaseObject {
    @JsonProperty(value="message_type")
    MessageType messageType;
    @JsonProperty(value="text")
    String text;
    @JsonProperty(value="image")
    UrlContainer image;
    @JsonProperty(value="audio")
    UrlContainer audio;
    @JsonProperty(value="video")
    UrlContainer video;
    @JsonProperty(value="file")
    UrlContainer file;
    @JsonProperty(value="vcard")
    UrlContainer vcard;
    @JsonProperty(value="location")
    Location location;
    @JsonProperty(value="template")
    WhatsappTemplate template;
    @JsonProperty(value="custom")
    Map<String, ?> custom;

    MessageEventBody() {
    }

    MessageEventBody(MessageEvent.Builder builder) {
        this.messageType = Objects.requireNonNull(builder.messageType, "Message type is required.");
        this.template = builder.template;
        if (this.template != null && this.messageType != MessageType.TEMPLATE) {
            throw new IllegalStateException("Template is not applicable to '" + (Object)((Object)this.messageType) + "'.");
        }
        this.custom = builder.custom;
        if (this.custom != null && this.messageType != MessageType.CUSTOM) {
            throw new IllegalStateException("Custom is not applicable to '" + (Object)((Object)this.messageType) + "'.");
        }
        this.text = builder.text;
        if (this.text != null && this.messageType != MessageType.TEXT) {
            throw new IllegalStateException("Text is not applicable to '" + (Object)((Object)this.messageType) + "'.");
        }
        this.location = builder.location;
        if (this.location != null && this.messageType != MessageType.LOCATION) {
            throw new IllegalStateException("Location is not applicable to '" + (Object)((Object)this.messageType) + "'.");
        }
        if (builder.url != null) {
            UrlContainer urlRef = new UrlContainer();
            urlRef.url = builder.url;
            switch (this.messageType) {
                default: {
                    throw new IllegalStateException("URL is not applicable for '" + (Object)((Object)this.messageType) + "'.");
                }
                case IMAGE: {
                    this.image = urlRef;
                    break;
                }
                case AUDIO: {
                    this.audio = urlRef;
                    break;
                }
                case VIDEO: {
                    this.video = urlRef;
                    break;
                }
                case FILE: {
                    this.file = urlRef;
                    break;
                }
                case VCARD: {
                    this.vcard = urlRef;
                }
            }
        }
    }

    static class UrlContainer
    extends JsonableBaseObject {
        @JsonProperty(value="url")
        URI url;

        UrlContainer() {
        }
    }
}

