/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.conversations.BaseConversationWithState;
import com.vonage.client.conversations.Callback;
import com.vonage.client.conversations.ConversationProperties;
import com.vonage.client.users.channels.Channel;
import com.vonage.client.users.channels.Pstn;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class Conversation
extends BaseConversationWithState {
    private Integer sequenceNumber;
    private ConversationProperties properties;
    private Collection<? extends Channel> numbers;
    private Callback callback;

    protected Conversation() {
    }

    Conversation(Builder builder) {
        this.name = builder.name;
        if (this.name != null && (this.name.length() > 100 || this.name.trim().isEmpty())) {
            throw new IllegalArgumentException("Name must be between 1 and 100 characters.");
        }
        this.displayName = builder.displayName;
        if (this.displayName != null && (this.displayName.length() > 50 || this.displayName.trim().isEmpty())) {
            throw new IllegalArgumentException("Display name must be between 1 and 50 characters.");
        }
        this.imageUrl = builder.imageUrl;
        this.properties = builder.properties;
        this.callback = builder.callback;
        this.numbers = builder.numbers;
        if (this.numbers != null) {
            this.numbers.forEach(Channel::setTypeField);
        }
    }

    @JsonProperty(value="sequence_number")
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    @JsonProperty(value="properties")
    public ConversationProperties getProperties() {
        return this.properties;
    }

    @JsonProperty(value="numbers")
    public Collection<? extends Channel> getNumbers() {
        return this.numbers;
    }

    @JsonProperty(value="callback")
    public Callback getCallback() {
        return this.callback;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String displayName;
        private URI imageUrl;
        private ConversationProperties properties;
        private Collection<? extends Channel> numbers;
        private Callback callback;

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            this.imageUrl = URI.create(imageUrl);
            return this;
        }

        public Builder properties(ConversationProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder phone(String ... phoneNumber) {
            return this.numbers((Channel[])Arrays.stream(phoneNumber).map(Pstn::new).toArray(Channel[]::new));
        }

        Builder numbers(Channel ... numbers) {
            return this.numbers(Arrays.asList(numbers));
        }

        Builder numbers(Collection<? extends Channel> numbers) {
            this.numbers = new ArrayList<Channel>(numbers);
            return this;
        }

        public Builder callback(Callback callback) {
            this.callback = callback;
            return this;
        }

        public Conversation build() {
            return new Conversation(this);
        }
    }
}

