/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.VonageUnexpectedException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public interface Jsonable {
    public static ObjectMapper createDefaultObjectMapper() {
        return new ObjectMapper().registerModule((Module)new JavaTimeModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    default public String toJson() {
        try {
            ObjectMapper mapper = this instanceof JsonableBaseObject ? ((JsonableBaseObject)this).createJsonObjectMapper() : Jsonable.createDefaultObjectMapper();
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jpe) {
            throw new VonageUnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName() + " object.", jpe);
        }
    }

    default public void updateFromJson(String json) {
        if (json == null || json.trim().isEmpty()) {
            return;
        }
        try {
            ObjectMapper mapper = this instanceof JsonableBaseObject ? ((JsonableBaseObject)this).createJsonObjectMapper() : Jsonable.createDefaultObjectMapper();
            mapper.readerForUpdating((Object)this).readValue(json);
        }
        catch (IOException ex) {
            throw new VonageResponseParseException("Failed to produce " + this.getClass().getSimpleName() + " from JSON.", ex);
        }
    }

    public static <J extends Jsonable> J fromJson(String json, J ... type) {
        return (J)Jsonable.fromJson(json, type.getClass().getComponentType());
    }

    public static <J extends Jsonable> J fromJson(String json, Class<? extends J> jsonable) {
        try {
            if (Modifier.isAbstract(jsonable.getModifiers())) {
                return (J)((Jsonable)Jsonable.createDefaultObjectMapper().readValue(json, jsonable));
            }
            Constructor<J> constructor = jsonable.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Jsonable instance = (Jsonable)constructor.newInstance(new Object[0]);
            instance.updateFromJson(json);
            return (J)instance;
        }
        catch (JsonProcessingException | ReflectiveOperationException ex) {
            throw new VonageUnexpectedException(ex);
        }
    }

    public static <E extends Enum<E>> E fromString(String value, Class<E> type) {
        try {
            return Enum.valueOf(type, value.toUpperCase().replace('-', '_').replace(':', '_'));
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            return null;
        }
    }
}

