/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.vonage.client.HttpConfig;
import com.vonage.client.auth.ApiKeyAuthMethod;
import com.vonage.client.auth.AuthCollection;
import com.vonage.client.auth.AuthMethod;
import com.vonage.client.auth.JWTAuthMethod;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpWrapper {
    private static final String CLIENT_NAME = "vonage-java-sdk";
    private static final String CLIENT_VERSION = "9.3.1";
    private static final String JAVA_VERSION = System.getProperty("java.version");
    private static final String USER_AGENT = String.format("%s/%s java/%s", "vonage-java-sdk", "9.3.1", JAVA_VERSION);
    private CloseableHttpClient httpClient;
    private HttpConfig httpConfig;
    private final AuthCollection authCollection;

    public HttpWrapper(HttpConfig httpConfig, AuthCollection authCollection, HttpClient httpClient) {
        this.authCollection = authCollection;
        this.httpConfig = httpConfig;
        this.httpClient = httpClient instanceof CloseableHttpClient ? (CloseableHttpClient)httpClient : this.createHttpClient();
    }

    public HttpWrapper(HttpConfig httpConfig, AuthCollection authCollection) {
        this(httpConfig, authCollection, null);
    }

    public HttpWrapper(AuthCollection authCollection) {
        this(HttpConfig.builder().build(), authCollection);
    }

    public HttpWrapper(AuthMethod ... authMethods) {
        this(HttpConfig.builder().build(), authMethods);
    }

    public HttpWrapper(HttpConfig httpConfig, AuthMethod ... authMethods) {
        this(httpConfig, new AuthCollection(authMethods));
    }

    @Deprecated
    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public UUID getApplicationId() {
        try {
            return UUID.fromString(this.getAuthCollection().getAuth(JWTAuthMethod.class).getApplicationId());
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public String getApiKey() {
        try {
            return this.getAuthCollection().getAuth(ApiKeyAuthMethod.class).getApiKey();
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public AuthCollection getAuthCollection() {
        return this.authCollection;
    }

    protected CloseableHttpClient createHttpClient() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(200);
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(StandardCharsets.UTF_8).build());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).build());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.httpConfig.getTimeoutMillis()).setConnectionRequestTimeout(this.httpConfig.getTimeoutMillis()).setSocketTimeout(this.httpConfig.getTimeoutMillis()).build();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setUserAgent(this.getUserAgent()).setDefaultRequestConfig(requestConfig).useSystemProperties().disableRedirectHandling();
        URI proxy = this.httpConfig.getProxy();
        if (proxy != null) {
            clientBuilder.setProxy(new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getScheme()));
        }
        return clientBuilder.build();
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public String getUserAgent() {
        String ua = USER_AGENT;
        String custom = this.httpConfig.getCustomUserAgent();
        if (custom != null) {
            ua = ua + " " + this.httpConfig.getCustomUserAgent();
        }
        return ua;
    }

    public String getClientVersion() {
        return CLIENT_VERSION;
    }
}

