/*
 *   Copyright 2025 Vonage
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Main body container for {@link AudioDtmfEvent}.
 *
 * @since 8.19.0
 */
class AudioDtmfEventBody extends AbstractChannelEvent.Body {
    @JsonAlias({"digit"}) @JsonProperty("digits") String digits;
    @JsonProperty("dtmf_seq") Integer dtmfSeq;

    AudioDtmfEventBody() {}

    AudioDtmfEventBody(AudioDtmfEvent.Builder builder) {
        super(builder);
        digits = builder.digits;
        dtmfSeq = builder.dtmfSeq;
    }
}
