/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.vonage.client.verify.VerifyStatusDeserializer;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(using=VerifyStatusDeserializer.class)
public enum VerifyStatus {
    OK(0),
    THROTTLED(1),
    MISSING_PARAMS(2),
    INVALID_PARAMS(3),
    INVALID_CREDENTIALS(4),
    INTERNAL_ERROR(5),
    INVALID_REQUEST(6),
    NUMBER_BARRED(7),
    PARTNER_ACCOUNT_BARRED(8),
    PARTNER_QUOTA_EXCEEDED(9),
    ALREADY_REQUESTED(10),
    UNSUPPORTED_NETWORK(15),
    INVALID_CODE(16),
    WRONG_CODE_THROTTLED(17),
    TOO_MANY_DESTINATIONS(18),
    NO_RESPONSE(101),
    COMMS_FAILURE(-1),
    UNKNOWN(Integer.MAX_VALUE);

    private int verifyStatus;
    private static final Map<Integer, VerifyStatus> VERIFY_STATUS_INDEX;

    public static VerifyStatus fromInt(int verifyStatus) {
        VerifyStatus foundVerifyStatus = VERIFY_STATUS_INDEX.get(verifyStatus);
        return foundVerifyStatus != null ? foundVerifyStatus : UNKNOWN;
    }

    private VerifyStatus(int verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    public int getVerifyStatus() {
        return this.verifyStatus;
    }

    public boolean isTemporaryError() {
        return this == THROTTLED || this == INTERNAL_ERROR;
    }

    static {
        VERIFY_STATUS_INDEX = new HashMap<Integer, VerifyStatus>();
        for (VerifyStatus verifyStatus : VerifyStatus.values()) {
            VERIFY_STATUS_INDEX.put(verifyStatus.verifyStatus, verifyStatus);
        }
    }
}

