/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageClientException;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.verify.ControlRequest;
import com.vonage.client.verify.ControlResponse;
import com.vonage.client.verify.VerifyException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

class ControlEndpoint
extends AbstractMethod<ControlRequest, ControlResponse> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/verify/control/json";

    ControlEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(ControlRequest request) throws UnsupportedEncodingException {
        RequestBuilder requestBuilder = RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH));
        request.addParams(requestBuilder);
        return requestBuilder;
    }

    @Override
    public ControlResponse parseResponse(HttpResponse response) throws IOException, VonageClientException {
        ControlResponse controlResponse = ControlResponse.fromJson(new BasicResponseHandler().handleResponse(response));
        if (!controlResponse.getStatus().equals("0")) {
            throw new VerifyException(controlResponse.getStatus(), controlResponse.getErrorText());
        }
        return controlResponse;
    }
}

