/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.numbers.SearchPattern;
import com.vonage.client.numbers.Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.RequestBuilder;

public class SearchNumbersFilter {
    private final String country;
    private String pattern;
    private SearchPattern searchPattern;
    private String[] features;
    private Integer index;
    private Integer size;
    private Type type;

    public SearchNumbersFilter(String country) {
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String[] getFeatures() {
        return this.features;
    }

    public void setFeatures(String[] features) {
        this.features = features;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public SearchPattern getSearchPattern() {
        return this.searchPattern;
    }

    public void setSearchPattern(SearchPattern searchPattern) {
        this.searchPattern = searchPattern;
    }

    public void addParams(RequestBuilder request) {
        request.addParameter("country", this.country);
        if (this.features != null && this.features.length > 0) {
            request.addParameter("features", StringUtils.join((Object[])this.features, (String)","));
        }
        if (this.index != null) {
            request.addParameter("index", this.index.toString());
        }
        if (this.size != null) {
            request.addParameter("size", this.size.toString());
        }
        if (this.pattern != null) {
            request.addParameter("pattern", this.pattern);
        }
        if (this.searchPattern != null) {
            request.addParameter("search_pattern", Integer.toString(this.searchPattern.getValue()));
        }
        if (this.type != null) {
            request.addParameter("type", this.type.getType());
        }
    }
}

