/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.numbers.BuyNumberEndpoint;
import com.vonage.client.numbers.BuyNumberRequest;
import com.vonage.client.numbers.CancelNumberEndpoint;
import com.vonage.client.numbers.CancelNumberRequest;
import com.vonage.client.numbers.ListNumbersEndpoint;
import com.vonage.client.numbers.ListNumbersFilter;
import com.vonage.client.numbers.ListNumbersResponse;
import com.vonage.client.numbers.SearchNumbersEndpoint;
import com.vonage.client.numbers.SearchNumbersFilter;
import com.vonage.client.numbers.SearchNumbersResponse;
import com.vonage.client.numbers.UpdateNumberEndpoint;
import com.vonage.client.numbers.UpdateNumberRequest;

public class NumbersClient {
    private ListNumbersEndpoint listNumbers;
    private SearchNumbersEndpoint searchNumbers;
    private CancelNumberEndpoint cancelNumber;
    private BuyNumberEndpoint buyNumber;
    private UpdateNumberEndpoint updateNumber;

    public NumbersClient(HttpWrapper httpWrapper) {
        this.listNumbers = new ListNumbersEndpoint(httpWrapper);
        this.searchNumbers = new SearchNumbersEndpoint(httpWrapper);
        this.cancelNumber = new CancelNumberEndpoint(httpWrapper);
        this.buyNumber = new BuyNumberEndpoint(httpWrapper);
        this.updateNumber = new UpdateNumberEndpoint(httpWrapper);
    }

    public ListNumbersResponse listNumbers() throws VonageResponseParseException, VonageClientException {
        return this.listNumbers.listNumbers(new ListNumbersFilter());
    }

    public ListNumbersResponse listNumbers(ListNumbersFilter filter) throws VonageResponseParseException, VonageClientException {
        return this.listNumbers.listNumbers(filter);
    }

    public SearchNumbersResponse searchNumbers(String country) throws VonageResponseParseException, VonageClientException {
        return this.searchNumbers(new SearchNumbersFilter(country));
    }

    public SearchNumbersResponse searchNumbers(SearchNumbersFilter filter) throws VonageResponseParseException, VonageClientException {
        return this.searchNumbers.searchNumbers(filter);
    }

    public void buyNumber(String country, String msisdn) throws VonageResponseParseException, VonageClientException {
        this.buyNumber.execute(new BuyNumberRequest(country, msisdn));
    }

    public void cancelNumber(String country, String msisdn) throws VonageResponseParseException, VonageClientException {
        this.cancelNumber.execute(new CancelNumberRequest(country, msisdn));
    }

    public void updateNumber(UpdateNumberRequest request) throws VonageResponseParseException, VonageClientException {
        this.updateNumber.execute(request);
    }

    public void linkNumber(String msisdn, String country, String appId) throws VonageResponseParseException, VonageClientException {
        UpdateNumberRequest request = new UpdateNumberRequest(msisdn, country);
        request.setVoiceCallbackType(UpdateNumberRequest.CallbackType.APP);
        request.setVoiceCallbackValue(appId);
        this.updateNumber(request);
    }
}

