/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum InsightStatus {
    SUCCESS(0),
    THROTTLED(1),
    INVALID_PARAMS(3),
    INVALID_CREDENTIALS(4),
    INTERNAL_ERROR(5),
    PARTNER_QUOTA_EXCEEDED(9),
    UNKNOWN(Integer.MAX_VALUE);

    private int insightStatus;
    private static final Map<Integer, InsightStatus> INSIGHT_STATUS_INDEX;

    @JsonCreator
    public static InsightStatus fromInt(int insightStatus) {
        InsightStatus foundInsightStatus = INSIGHT_STATUS_INDEX.get(insightStatus);
        return foundInsightStatus != null ? foundInsightStatus : UNKNOWN;
    }

    private InsightStatus(int insightStatus) {
        this.insightStatus = insightStatus;
    }

    public int getInsightStatus() {
        return this.insightStatus;
    }

    static {
        INSIGHT_STATUS_INDEX = new HashMap<Integer, InsightStatus>();
        for (InsightStatus insightStatus : InsightStatus.values()) {
            INSIGHT_STATUS_INDEX.put(insightStatus.insightStatus, insightStatus);
        }
    }
}

